/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import stream.AbstractProcessor;
import stream.Context;
import stream.Data;
import stream.ProcessContext;
import stream.expressions.ExpressionResolver;

public class SendUDP
extends AbstractProcessor {
    Integer port;
    String address;
    String message;
    DatagramSocket socket;
    InetAddress addr;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.socket = new DatagramSocket();
        if (this.port == null || this.port < 1024) {
            throw new Exception("Invalid port, needs to be > 1024!");
        }
        this.addr = InetAddress.getByName(this.address);
    }

    public Data process(Data input) {
        try {
            String msg = ExpressionResolver.expand((String)this.message, (Context)this.context, (Data)input) + "\n";
            byte[] buf = msg.getBytes();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, this.addr, this.port);
            this.socket.send(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return input;
    }
}

