/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.InetSocketAddress;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.data.DataFactory;
import stream.laser.Calibration;
import stream.laser.Drawable;
import stream.laser.LaserSound;
import stream.laser.LaserSword;
import stream.laser.Trapez;
import stream.laser.WindowInfo;
import stream.laser.game.LaserMazeResult;
import stream.laser.game.LaserMazeResult2;
import stream.laser.game.LevelScore;
import stream.laser.game.NameDialog;
import stream.laser.game.PointT;
import stream.laser.game.TrackListener;
import stream.net.NetworkPointer;
import stream.net.PointerListener;
import stream.runtime.ProcessContextImpl;

public class SteelPanel
extends JPanel
implements PointerListener {
    private static final long serialVersionUID = -1683540875635107889L;
    static Logger log = LoggerFactory.getLogger(SteelPanel.class);
    int level = 0;
    String[] levels = new String[]{"/laser/game/images/background8.png", "/laser/game/images/background9.png", "/laser/game/images/background10.png"};
    final LaserMazeResult result = new LaserMazeResult();
    final LaserMazeResult2 scorer = new LaserMazeResult2();
    final LevelScore levelScore = new LevelScore();
    boolean debug = "true".equalsIgnoreCase(System.getProperty("debug"));
    TrackListener trackListener;
    String name = null;
    URL currentLevelUrl;
    LaserSword sword = new LaserSword();
    ImageIcon icon;
    ArrayList<PointT> cut = new ArrayList();
    int flameWidth = 20;
    int flameHeight = 20;
    PointT lastPoint = null;
    final List<Drawable> drawables = new ArrayList<Drawable>();
    BufferedImage backgroundImage;
    Point start;
    Point end;
    int radius = 25;
    int state = 0;
    boolean flame = false;
    Double score = null;
    Long startTime = 0L;
    Long endTime = 0L;
    long errors = 0L;
    long onPath = 0L;
    Trapez trapez = null;
    boolean drawTrapez = false;
    LaserSound sound = new LaserSound();
    private List<Point> pts;
    private List<Point> chkPts;

    public SteelPanel() {
        this.addMouseMotionListener(this.sword);
        this.addMouseListener(this.sword);
        this.icon = this.sword.getFlame();
        this.pts = new ArrayList<Point>();
        this.chkPts = new ArrayList<Point>();
        this.setBackground(Color.BLUE);
        this.sound.init();
        try {
            this.trackListener = new TrackListener();
            this.trackListener.init((ProcessContext)new ProcessContextImpl());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage());
        }
    }

    public void setTrapez(Trapez t) {
        this.trapez = t;
    }

    public void resetState() {
        this.state = 0;
        this.startTime = 0L;
        this.endTime = 0L;
        this.errors = 0L;
        this.onPath = 0L;
        this.lastPoint = null;
        this.repaint();
        this.validate();
        this.cut.clear();
    }

    public void setLevel(int lev) {
        this.level = lev % this.levels.length;
        URL url = SteelPanel.class.getResource(this.levels[this.level]);
        this.setBackgroundImage(url);
        this.resetState();
    }

    public void setBackgroundImage(URL url) {
        try {
            log.debug("Reading image from {}", (Object)url);
            this.backgroundImage = ImageIO.read(url);
            BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), this.backgroundImage.getType());
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(this.backgroundImage, 0, 0, bi.getWidth(), bi.getHeight(), null);
            g2.dispose();
            this.backgroundImage = bi;
            this.start = null;
            this.end = null;
            log.debug("Background image is: {}", (Object)this.backgroundImage);
            TreeSet<String> colors = new TreeSet<String>();
            for (int x = 0; x < this.backgroundImage.getWidth(); ++x) {
                for (int y = 0; y < this.backgroundImage.getHeight(); ++y) {
                    int argb = this.backgroundImage.getRGB(x, y);
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    String c = "(" + r + "," + g + "," + b + ")";
                    colors.add(c);
                    if (this.start == null && r == 181 && g == 0 && b == 18) {
                        this.start = new Point(x, y);
                        log.debug("Found start-point at {}", (Object)this.start);
                    }
                    if (this.start == null && r == 255 && g == 255 && b == 255) {
                        this.start = new Point(x, y);
                        log.debug("Found start-point at {}", (Object)this.start);
                    }
                    if (this.start == null && r == 226 && g == 45 && b == 45) {
                        this.start = new Point(x, y);
                        log.debug("Found start-point at {}", (Object)this.start);
                    }
                    if (this.end == null && r == 0 && g == 0 && b == 199) {
                        this.end = new Point(x, y);
                        log.debug("Found end-point at {}", (Object)this.end);
                    }
                    if (this.end == null && r == 45 && g == 45 && b == 226) {
                        this.end = new Point(x, y);
                        log.debug("Found end-point at {}", (Object)this.end);
                    }
                    this.drawRand(x, y, this.backgroundImage, this.pts);
                }
            }
            log.info("colors: {}", colors);
            this.repaint();
            this.validate();
            this.currentLevelUrl = url;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawRand(int x, int y, BufferedImage img, List<Point> pts) {
        int r = 0;
        int g = 255;
        int b = 255;
        int color = r;
        color = (color << 8) + g;
        color = (color << 8) + b;
        if (this.test1(x, y, img)) {
            img.setRGB(x, y, color);
            pts.add(new Point(x, y));
            return;
        }
        if (this.test2(x, y, img)) {
            img.setRGB(x, y, color);
            pts.add(new Point(x, y));
            return;
        }
        if (this.test3(x, y, img)) {
            img.setRGB(x, y, color);
            pts.add(new Point(x, y));
            return;
        }
    }

    private boolean test1(int x, int y, BufferedImage img) {
        int xk = x - 1;
        int yk = y + 1;
        boolean t1 = this.testColor(xk, yk, 0, 0, 0, img);
        if (t1) {
            xk = x + 1;
            yk = y - 1;
            boolean t2 = this.testColor(xk, yk, 0, 0, 0, img);
            if (t2) {
                xk = x + 1;
                yk = y + 1;
                boolean t3 = this.testColor(xk, yk, 156, 156, 156, img);
                if (t3) {
                    xk = x - 1;
                    yk = y - 1;
                    return this.testColor(xk, yk, 0, 0, 0, img);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean test2(int x, int y, BufferedImage img) {
        int xk = x - 1;
        int yk = y - 1;
        boolean t1 = this.testColor(xk, yk, 0, 0, 0, img);
        if (t1) {
            xk = x + 1;
            yk = y + 1;
            boolean t2 = this.testColor(xk, yk, 0, 0, 0, img);
            if (t2) {
                xk = x + 1;
                yk = y - 1;
                boolean t3 = this.testColor(xk, yk, 156, 156, 156, img);
                if (t3) {
                    xk = x - 1;
                    yk = y + 1;
                    return this.testColor(xk, yk, 0, 0, 0, img);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean test3(int x, int y, BufferedImage img) {
        int xk = x + 1;
        int yk = y + 1;
        boolean t1 = this.testColor(xk, yk, 0, 0, 0, img);
        if (t1) {
            xk = x - 1;
            yk = y - 1;
            boolean t2 = this.testColor(xk, yk, 156, 156, 156, img);
            if (t2) {
                xk = x - 1;
                yk = y + 1;
                boolean t3 = this.testColor(xk, yk, 156, 156, 156, img);
                if (t3) {
                    xk = x + 1;
                    yk = y - 1;
                    return this.testColor(xk, yk, 156, 156, 156, img);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean testColor(int x, int y, int r, int g, int b, BufferedImage img) {
        if (x > -1 && y > -1 && x < img.getWidth() && y < img.getHeight()) {
            int argb = img.getRGB(x, y);
            int rt = argb >> 16 & 0xFF;
            int gt = argb >> 8 & 0xFF;
            int bt = argb & 0xFF;
            if (rt == r && gt == g && bt == b) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.backgroundImage != null) {
            g2.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), null);
        }
        PointT last = null;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(2.75f));
        if (this.start != null) {
            g2.setColor(Color.BLUE);
            g2.drawOval(this.start.x - this.radius, this.start.y - this.radius, this.radius * 2, this.radius * 2);
            if (this.lastPoint != null && this.state == 0 && this.start.distance(this.lastPoint) < (double)this.radius) {
                this.state = 1;
            }
        }
        if (this.end != null) {
            g2.setColor(Color.RED);
            g2.drawOval(this.end.x - this.radius, this.end.y - this.radius, this.radius * 2, this.radius * 2);
        }
        g.setColor(Color.white);
        String nameInfo = "Name: " + this.name;
        Rectangle2D rect = g2.getFont().getStringBounds(nameInfo, g2.getFontRenderContext());
        g2.drawString(nameInfo, this.getWidth() - (int)rect.getWidth() - 4, 0 + (int)rect.getHeight() + 0);
        String info = "State is: " + this.state + " (Level " + this.level + ")";
        rect = g2.getFont().getStringBounds(info, g2.getFontRenderContext());
        g2.drawString(info, this.getWidth() - (int)rect.getWidth() - 4, 0 + (int)rect.getHeight() + 14);
        if (this.startTime > 0L && this.state == 2) {
            Long elapsed = System.currentTimeMillis() - this.startTime;
            if (this.endTime > 0L) {
                elapsed = this.endTime - this.startTime;
            }
            if (this.debug) {
                g2.drawString("Time elapsed: " + elapsed + " ms", this.getWidth() - 300, 45);
                g2.drawString("Errors: " + this.errors, this.getWidth() - 300, 60);
                g2.drawString("On path: " + this.onPath, this.getWidth() - 300, 75);
            }
            if (this.score != null) {
                Font bold = g2.getFont().deriveFont(1).deriveFont(36.0f);
                g2.setFont(bold);
                DecimalFormat fmt = new DecimalFormat("0");
                String scoreString = "Your Score: " + fmt.format(this.score);
                rect = g2.getFont().getStringBounds(scoreString, g2.getFontRenderContext());
                g2.drawString(scoreString, this.getWidth() / 2 - (int)rect.getWidth() / 2, this.getHeight() / 2);
            }
        }
        g.setColor(Color.RED);
        ArrayList<PointT> points = this.cut;
        for (int i = 0; i < points.size(); ++i) {
            PointT p = points.get(i);
            if (last == null) {
                last = p;
            }
            g.drawLine(last.x, last.y, p.x, p.y);
            last = p;
            if (i + 1 >= points.size() && this.icon != null && this.flame) {
                g.drawImage(this.icon.getImage(), p.x - this.flameWidth / 2, p.y - this.flameHeight, this.flameWidth, this.flameHeight, this.icon.getImageObserver());
            }
            if (this.cut.contains(p)) continue;
            this.cut.add(p);
        }
        for (Drawable d : this.drawables) {
            if (!d.isVisible()) continue;
            d.draw(g2);
        }
        if (this.trapez != null && this.drawTrapez) {
            this.trapez.draw(g2);
        }
    }

    public static void main(String[] args) throws Exception {
        final JFrame frame = new JFrame();
        System.setProperty("trapezKorrektur", "true");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        screen = new Dimension(1024, 768);
        final SteelPanel panel = new SteelPanel();
        InetSocketAddress addr = null;
        if (args.length > 1) {
            addr = new InetSocketAddress(args[0], (int)new Integer(args[1]));
        }
        if (args.length > 0) {
            addr = new InetSocketAddress(args[0], 9100);
        }
        int marginTop = new Integer(System.getProperty("marginTop", "36"));
        Integer w = new Integer(System.getProperty("width", "" + screen.width));
        Integer h = new Integer(System.getProperty("height", "" + (screen.height - marginTop)));
        Integer x = new Integer(System.getProperty("x", "0"));
        Integer y = new Integer(System.getProperty("y", "" + (0 + marginTop)));
        NetworkPointer pointer = null;
        if (addr != null) {
            pointer = new NetworkPointer(addr);
            pointer.setDaemon(true);
            pointer.start();
        }
        frame.getContentPane().add(panel);
        frame.setSize(w, h);
        frame.addComponentListener(new WindowInfo(frame));
        frame.setLocation(x, y);
        frame.setVisible(true);
        panel.setLevel(0);
        final Calibration c = new Calibration(panel);
        if (pointer != null) {
            pointer.addListener(c);
        }
        frame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == 'c' || e.getKeyChar() == 'r') {
                    panel.clearChkPts();
                    log.info("Performing clear-action...");
                    panel.resetState();
                }
                if (e.getKeyChar() == 'C') {
                    log.info("Performing calibration-action...");
                    c.nextMark();
                }
                if (e.getKeyChar() == 's') {
                    panel.state = (panel.state + 1) % 3;
                    panel.repaint();
                    panel.validate();
                }
                if (e.getKeyChar() == 'p') {
                    log.info("Enable Piatkowski-Correction...");
                    System.setProperty("trapezKorrektur", "true");
                }
                if (e.getKeyChar() == 't') {
                    panel.drawTrapez = !panel.drawTrapez;
                    panel.repaint();
                    panel.validate();
                }
                if (e.getKeyChar() == 'f') {
                    boolean bl = panel.flame = !panel.flame;
                }
                if (e.getKeyChar() == 'n') {
                    NameDialog d = new NameDialog(frame);
                    d.center();
                    d.setVisible(true);
                    panel.setUserName(d.getName());
                }
                if (e.getKeyChar() == 'l') {
                    panel.clearPts();
                    panel.level = (panel.level + 1) % panel.levels.length;
                    panel.setLevel(panel.level);
                    panel.repaint();
                    panel.validate();
                }
            }
        });
        panel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.isShiftDown() && c != null) {
                    c.pointingAt(e.getX(), e.getY());
                }
            }
        });
    }

    private void clearPts() {
        this.pts.clear();
    }

    private void clearChkPts() {
        this.chkPts.clear();
    }

    public void setUserName(String n) {
        this.name = n;
        this.repaint();
        this.validate();
    }

    @Override
    public void pointingAt(int x, int y) {
        this.lastPoint = new PointT(x, y);
        boolean inCircle = false;
        this.sword.active = true;
        Data item = DataFactory.create();
        if (this.name != null) {
            item.put((Object)"user", (Object)this.name);
        }
        item.put((Object)"level:", (Object)this.level);
        item.put((Object)"track:x", (Object)x);
        item.put((Object)"track:y", (Object)y);
        if (this.start != null && this.state == 0) {
            Point point = new Point(x, y);
            if (this.start.distance(point) < (double)this.radius) {
                this.chkPts.clear();
                this.chkPts.addAll(this.pts);
                log.info("Pointer in start-circle!");
                this.state = 1;
                this.startTime = System.currentTimeMillis();
                if (!inCircle) {
                    // empty if block
                }
                inCircle = true;
                this.sound.play("on0");
                if (this.currentLevelUrl != null && this.backgroundImage != null) {
                    item.put((Object)"image:url", (Object)this.currentLevelUrl.toString());
                    item.put((Object)"image:width", (Object)this.backgroundImage.getWidth());
                    item.put((Object)"image:height", (Object)this.backgroundImage.getHeight());
                }
                item.put((Object)"track:point", (Object)"start");
            }
        }
        if (this.end != null && this.state == 1) {
            Point point = new Point(x, y);
            if (this.end.distance(point) < (double)this.radius && Math.abs(this.chkPts.size() - this.pts.size()) > 10) {
                log.info("#chkPoints {}", (Object)this.chkPts.size());
                log.info("Point in end-circle!");
                this.state = 2;
                this.endTime = System.currentTimeMillis();
                if (!inCircle) {
                    // empty if block
                }
                inCircle = true;
                this.sound.play("off0");
                item.put((Object)"level", (Object)("" + this.level));
                item.put((Object)"track:point", (Object)"end");
                item.put((Object)"time", (Object)(this.endTime - this.startTime));
                item.put((Object)"onpath", (Object)this.onPath);
                item.put((Object)"error", (Object)this.errors);
                item = this.result.process(item);
                item = this.scorer.process(item);
                log.info("item: {}", (Object)item);
                item = this.levelScore.process(item);
                log.info("mapped: {}", (Object)item);
                try {
                    this.score = item.containsKey((Object)"@punkte") ? new Double("" + item.get((Object)"@punkte")) : Double.valueOf(Double.NaN);
                }
                catch (Exception e) {
                    this.score = null;
                }
                if (this.trackListener != null) {
                    this.trackListener.process(item);
                }
            }
        }
        if (this.state == 1) {
            this.cut.add(this.lastPoint);
        }
        if (this.backgroundImage != null) {
            if (x < 0 || x > this.backgroundImage.getWidth()) {
                return;
            }
            if (y < 0 || y > this.backgroundImage.getHeight()) {
                return;
            }
            try {
                this.checkPoints(x, y);
                if (!inCircle && this.state == 1) {
                    int argb = this.backgroundImage.getRGB(x, y);
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    if (r == 156 && g == 156 && b == 156) {
                        ++this.onPath;
                    } else {
                        int count = this.calcErrorIntensity(x, y, this.backgroundImage);
                        this.errors = count > 0 ? ++this.errors : (this.errors += 3L);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.state == 1 && this.trackListener != null) {
            this.trackListener.process(item);
        }
        this.repaint();
        this.validate();
    }

    private void checkPoints(int x, int y) {
        int r = -1;
        Point p = new Point(x, y);
        for (int i = 0; i < this.chkPts.size(); ++i) {
            Point pi = this.chkPts.get(i);
            if (!(pi.distance(p) < 60.0)) continue;
            r = i;
            break;
        }
        if (r > -1) {
            this.chkPts.remove(r);
        }
    }

    private int calcErrorIntensity(int x, int y, BufferedImage img) {
        int b;
        int g;
        int r;
        int argb;
        int size = 10;
        int count = 0;
        int xk = x + size;
        int yk = y;
        if (x < img.getWidth()) {
            argb = img.getRGB(xk, yk);
            r = argb >> 16 & 0xFF;
            g = argb >> 8 & 0xFF;
            b = argb & 0xFF;
            if (r != 156 || g != 156 || b != 156) {
                ++count;
            }
        }
        xk = x - size;
        yk = y;
        if (x > 0) {
            argb = img.getRGB(xk, yk);
            r = argb >> 16 & 0xFF;
            g = argb >> 8 & 0xFF;
            b = argb & 0xFF;
            if (r != 156 || g != 156 || b != 156) {
                ++count;
            }
        }
        xk = x;
        yk = y + size;
        if (y < img.getHeight()) {
            argb = img.getRGB(xk, yk);
            r = argb >> 16 & 0xFF;
            g = argb >> 8 & 0xFF;
            b = argb & 0xFF;
            if (r != 156 || g != 156 || b != 156) {
                ++count;
            }
        }
        xk = x;
        yk = y - size;
        if (y > 0) {
            argb = img.getRGB(xk, yk);
            r = argb >> 16 & 0xFF;
            g = argb >> 8 & 0xFF;
            b = argb & 0xFF;
            if (r != 156 || g != 156 || b != 156) {
                ++count;
            }
        }
        return count;
    }

    public void add(Drawable d) {
        this.drawables.add(d);
    }

    public void remove(Drawable d) {
        this.drawables.remove(d);
    }

    public void drawableChanged() {
        this.repaint();
        this.validate();
    }
}

