/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class TurboDiffImage
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(TurboDiffImage.class);
    protected ImageRGB lastImage = new ImageRGB(0, 0);
    private int threshold = -1;

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        ImageRGB diffImage = new ImageRGB(img.width, img.height, new int[img.width * img.height]);
        if (diffImage.height == this.lastImage.height && diffImage.width == this.lastImage.width) {
            int off = 0;
            int max = diffImage.width * diffImage.height;
            int idx = off;
            while (idx + 1 < max) {
                int rgbold = this.lastImage.pixels[idx];
                int rgbnew = img.pixels[idx];
                int p = rgbold >> 8;
                int gold = p & 0xFF;
                int rold = (p >>= 8) & 0xFF;
                int bold = rgbold & 0xFF;
                p = rgbnew >> 8;
                int gnew = p & 0xFF;
                int rnew = (p >>= 8) & 0xFF;
                int bnew = rgbnew & 0xFF;
                int rdiff = Math.abs(rold - rnew);
                int gdiff = Math.abs(gold - gnew);
                int bdiff = Math.abs(bold - bnew);
                if (this.threshold > 0) {
                    if (rdiff < this.threshold) {
                        rdiff = 0;
                    }
                    if (gdiff < this.threshold) {
                        gdiff = 0;
                    }
                    if (bdiff < this.threshold) {
                        bdiff = 0;
                    }
                }
                int rgbdiff = rdiff;
                rgbdiff = (rgbdiff << 8) + gdiff;
                diffImage.pixels[idx] = rgbdiff = (rgbdiff << 8) + bdiff;
                ++idx;
            }
        }
        this.lastImage = img;
        item.remove((Object)"data");
        item.put((Object)"data", (Object)diffImage);
        return item;
    }
}

