/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class TurboDiffImageMultithread
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(TurboDiffImageMultithread.class);
    protected ImageRGB lastImage = new ImageRGB(0, 0);
    int threshold = -1;
    int threadCount = 4;
    DiffThread[] worker = new DiffThread[this.threadCount];
    Future<Boolean>[] threads = new Future[this.threadCount];
    ExecutorService executorService;

    public TurboDiffImageMultithread() {
        for (int i = 0; i < this.threadCount; ++i) {
            this.worker[i] = new DiffThread();
        }
        this.executorService = Executors.newFixedThreadPool(this.threadCount);
    }

    public void finish() throws Exception {
        super.finish();
        this.executorService.shutdownNow();
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        ImageRGB diffImage = this.copy(img);
        if (diffImage.height == this.lastImage.height && diffImage.width == this.lastImage.width) {
            int t;
            int max = diffImage.width * diffImage.height;
            int share = max / this.threadCount;
            for (t = 0; t < this.threadCount; ++t) {
                this.worker[t].init(this.lastImage, img, t * share, (t + 1) * share, diffImage);
                this.threads[t] = this.executorService.submit(this.worker[t]);
            }
            for (t = 0; t < this.threadCount; ++t) {
                try {
                    this.threads[t].get();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.lastImage = img;
        item.remove((Object)"data");
        item.put((Object)"data", (Object)diffImage);
        return item;
    }

    private ImageRGB copy(ImageRGB img) {
        int[] pixels = new int[img.pixels.length];
        for (int i = 0; i < img.pixels.length; ++i) {
            pixels[i] = img.pixels[i];
        }
        return new ImageRGB(img.width, img.height, pixels);
    }

    public class DiffThread
    implements Callable<Boolean> {
        ImageRGB lastImage;
        ImageRGB diffImage;
        ImageRGB img;
        int offset;
        int max;

        public void init(ImageRGB last, ImageRGB img, int offset, int max, ImageRGB diffImage) {
            this.lastImage = last;
            this.diffImage = diffImage;
            this.img = img;
            this.offset = offset;
            this.max = max;
        }

        @Override
        public Boolean call() {
            for (int idx = this.offset; idx < this.max; ++idx) {
                int rgbold = this.lastImage.pixels[idx];
                int rgbnew = this.img.pixels[idx];
                int rold = rgbold >> 16 & 0xFF;
                int gold = rgbold >> 8 & 0xFF;
                int bold = rgbold & 0xFF;
                int rnew = rgbnew >> 16 & 0xFF;
                int gnew = rgbnew >> 8 & 0xFF;
                int bnew = rgbnew & 0xFF;
                int rdiff = Math.abs(rold - rnew);
                int gdiff = Math.abs(gold - gnew);
                int bdiff = Math.abs(bold - bnew);
                if (TurboDiffImageMultithread.this.threshold > 0) {
                    if (rdiff < TurboDiffImageMultithread.this.threshold) {
                        rdiff = 0;
                    }
                    if (gdiff < TurboDiffImageMultithread.this.threshold) {
                        gdiff = 0;
                    }
                    if (bdiff < TurboDiffImageMultithread.this.threshold) {
                        bdiff = 0;
                    }
                }
                int rgbdiff = rdiff;
                rgbdiff = (rgbdiff << 8) + gdiff;
                this.diffImage.pixels[idx] = rgbdiff = (rgbdiff << 8) + bdiff;
            }
            return true;
        }
    }
}

