/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class TurboGreenDiffImage
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(TurboGreenDiffImage.class);
    protected ImageRGB lastImage = new ImageRGB(0, 0);
    protected int threshold = -1;
    protected String output = this.imageKey;

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        ImageRGB diffImage = new ImageRGB(img.width, img.height, new int[img.width * img.height]);
        if (diffImage.height == this.lastImage.height && diffImage.width == this.lastImage.width) {
            int max = diffImage.width * diffImage.height;
            int idx = 0;
            while (idx + 1 < max) {
                int rgbold = this.lastImage.pixels[idx];
                int gold = rgbold >> 8 & 0xFF;
                int rgbnew = img.pixels[idx];
                int gnew = rgbnew >> 8 & 0xFF;
                int rdiff = Math.abs(gold - gnew);
                if (rdiff > this.threshold) {
                    diffImage.pixels[idx] = rdiff << 8;
                }
                ++idx;
            }
        }
        this.lastImage = img;
        item.put((Object)this.output, (Object)diffImage);
        return item;
    }
}

