/*
 * Decompiled with CFR 0.152.
 */
package stream.laser.game;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;

public class TrackListener
extends AbstractProcessor
implements Runnable {
    static Logger log = LoggerFactory.getLogger(TrackListener.class);
    File file;
    PrintStream out;
    boolean running = false;
    LinkedBlockingQueue<Data> items = new LinkedBlockingQueue();
    PrintStream scores;

    public TrackListener() throws IOException {
        this.file = new File("/tmp/laser-game.dat");
        this.out = new PrintStream(new FileOutputStream(this.file, true));
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        File scoreFile = new File(System.getProperty("user.home") + File.separator + "laser-scores.json");
        this.scores = new PrintStream(new FileOutputStream(scoreFile, true));
        Thread t = new Thread(this);
        t.start();
    }

    public Data process(Data input) {
        try {
            if (input == null) {
                return input;
            }
            this.items.add(input);
            return input;
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
    }

    public void finish() throws Exception {
        super.finish();
        this.running = false;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            while (!this.items.isEmpty()) {
                try {
                    Data item = this.items.take();
                    if (this.out == null || "start".equalsIgnoreCase(item.get((Object)"track:point") + "")) {
                        if (this.out != null) {
                            this.out.flush();
                            this.out.close();
                        }
                        File file = new File(System.getProperty("user.home") + File.separator + "trace-" + item.get((Object)"user") + "-" + System.currentTimeMillis() + ".json");
                        log.info("Creating new trace-file {}", (Object)file);
                        this.out = new PrintStream(new FileOutputStream(file));
                    }
                    String json = JSONObject.toJSONString((Map)item);
                    if (this.out != null) {
                        this.out.println(json);
                    } else {
                        log.error("No output stream given to write traces to...");
                    }
                    if (!item.containsKey((Object)"time")) continue;
                    this.scores.println(json);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.out.flush();
            this.out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

