/*
 * Decompiled with CFR 0.152.
 */
package stream.net;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.net.PointerListener;

public class NetworkPointer
extends Thread {
    static Logger log = LoggerFactory.getLogger(NetworkPointer.class);
    DatagramSocket socket;
    final List<PointerListener> listener = new ArrayList<PointerListener>();

    public NetworkPointer(InetSocketAddress addr) throws Exception {
        this.socket = new DatagramSocket(addr);
        log.info("socket bound to {}", (Object)this.socket.getLocalSocketAddress());
        log.info("NetworkPointer listening on UDP port {}", (Object)addr.getPort());
    }

    public void addListener(PointerListener l) {
        this.listener.add(l);
    }

    @Override
    public void run() {
        Pattern pattern = Pattern.compile("^\\((\\d+),(\\d+)\\)$");
        while (this.socket.isBound()) {
            try {
                byte[] buf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
                this.socket.receive(packet);
                String input = new String(packet.getData());
                Matcher m = pattern.matcher(input = input.trim());
                if (!m.find()) continue;
                String x = m.group(1);
                String y = m.group(2);
                try {
                    int px = new Integer(x);
                    int py = new Integer(y);
                    for (PointerListener l : this.listener) {
                        l.pointingAt(px, py);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            NetworkPointer pointer = new NetworkPointer(new InetSocketAddress("127.0.0.1", 9100));
            pointer.addListener(new PointerListener(){

                @Override
                public void pointingAt(int x, int y) {
                    log.info("Pointer pointing at {},{}", (Object)x, (Object)y);
                }
            });
            pointer.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

