/*
 * Decompiled with CFR 0.152.
 */
package stream.net;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.io.MJpegImageStreamOld;
import stream.io.SourceURL;
import stream.run;

public class StreamServer {
    static Logger log = LoggerFactory.getLogger(StreamServer.class);
    public static String[] logSearchPath = new String[]{""};
    final ServerSocket server;
    final List<ClientHandler> clients = new ArrayList<ClientHandler>();
    final Thread inputDispatcher;
    int delay = 0;
    int clientBuffer = 100;

    public StreamServer(int port, final InputStream input) throws Exception {
        this.server = new ServerSocket(port);
        this.delay = new Integer(System.getProperty("delay", "0"));
        this.inputDispatcher = new Thread(){
            Logger log = LoggerFactory.getLogger((String)"InputDispatcherThread");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MJpegImageStreamOld stream = new MJpegImageStreamOld(input);
                    stream.init();
                    int frame = 0;
                    Data item = stream.readNext();
                    while (item != null) {
                        try {
                            List<ClientHandler> list = StreamServer.this.clients;
                            synchronized (list) {
                                if (StreamServer.this.clients.isEmpty()) {
                                    this.log.info("Dropping frame {}", (Object)frame);
                                } else {
                                    this.log.info("Sending frame {}", (Object)frame);
                                    for (ClientHandler handler : StreamServer.this.clients) {
                                        handler.add((byte[])item.get((Object)"data"));
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++frame;
                        if (StreamServer.this.delay > 0) {
                            Thread.sleep(StreamServer.this.delay);
                        }
                        item = stream.readNext();
                    }
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (!this.inputDispatcher.isAlive()) {
            log.info("Starting input-dispatcher...");
            this.inputDispatcher.start();
        }
        try {
            while (true) {
                Socket socket = this.server.accept();
                log.info("new client connection: {}", (Object)socket);
                List<ClientHandler> list = this.clients;
                synchronized (list) {
                    ClientHandler handler = new ClientHandler(socket, this.clientBuffer, this);
                    handler.start();
                    List<ClientHandler> list2 = this.clients;
                    synchronized (list2) {
                        this.clients.add(handler);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(ClientHandler client) {
        List<ClientHandler> list = this.clients;
        synchronized (list) {
            this.clients.remove(client);
        }
    }

    public static void main(String[] args) {
        block3: {
            try {
                StreamServer.setupLogging();
                List params = run.handleArguments((String[])args);
                if (params.isEmpty()) {
                    log.info("You need to specify the source-URL to stream from!");
                    return;
                }
                SourceURL url = new SourceURL((String)params.get(params.size() - 1));
                log.info("Reading MJpegStream from {}", (Object)url);
                int port = new Integer(System.getProperty("port", "9100"));
                log.info("Starting server on port {}", (Object)port);
                StreamServer server = new StreamServer(port, url.openStream());
                server.run();
            }
            catch (Exception e) {
                log.error("Error while running StreamServer: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void setupLogging() {
        ArrayList<String> searchPaths = new ArrayList<String>();
        if (System.getenv("STREAMS_HOME") != null) {
            searchPaths.add(System.getenv("STREAMS_HOME") + File.separator + "conf");
        }
        for (String path : logSearchPath) {
            searchPaths.add(path);
        }
        for (String path : searchPaths) {
            String p = path;
            p = !p.isEmpty() ? path + File.separator + "log4j.properties" : "log4j.properties";
            File logProp = new File(p);
            if (!logProp.canRead()) continue;
            System.err.println("Using log settings from " + logProp.getAbsolutePath());
            try {
                Class<?> configurator = Class.forName("org.apache.log4j.PropertyConfigurator");
                Method configure = configurator.getMethod("configure", String.class);
                configure.invoke(null, logProp.getAbsolutePath());
                break;
            }
            catch (Exception e) {
                System.err.println("Failed to setup logging with log4j.properties: " + e.getMessage());
            }
        }
    }

    public static final class ClientHandler
    extends Thread {
        static final Logger log = LoggerFactory.getLogger(ClientHandler.class);
        final Socket socket;
        final LinkedBlockingQueue<byte[]> chunks = new LinkedBlockingQueue();
        final int clientBuffer;
        final StreamServer server;

        public ClientHandler(Socket sock, int clientBuffer, StreamServer server) {
            this.socket = sock;
            this.clientBuffer = clientBuffer;
            this.server = server;
        }

        @Override
        public void run() {
            while (this.socket.isConnected()) {
                try {
                    byte[] chunk = null;
                    chunk = this.chunks.take();
                    if (chunk == null) continue;
                    this.socket.getOutputStream().write(chunk);
                }
                catch (SocketException se) {
                    log.error("Socket error: {}", (Object)se.getMessage());
                    log.info("Disconnecting client...");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            log.info("Client handler for {} exiting...", (Object)this.socket);
            this.chunks.clear();
        }

        public void add(byte[] chunk) {
            if (this.chunks.size() > this.clientBuffer) {
                log.debug("Client buffer of size {} exceeded, dropping chunk", (Object)this.clientBuffer);
                this.chunks.remove();
                this.chunks.add(chunk);
            }
        }
    }
}

