/*
 * Decompiled with CFR 0.152.
 */
package stream.news.helper;

import java.util.HashMap;
import java.util.Map;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;
import stream.io.CsvStream;
import stream.io.SourceURL;

public class AddNewsshowLabels
extends AbstractProcessor {
    String file = "file:///C:/Users/Matthias/Documents/SchulteSVN/Diplomarbeit/data/news20120911/transitions.csv";
    private Map<Long, String> labels = new HashMap<Long, String>();
    private String lastlabel = "intro";

    @Parameter(description="Sets the file the labels are stored in.")
    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void init(ProcessContext ctx) throws Exception {
        Integer counterCuts = 0;
        Integer counterGT = 0;
        CsvStream stream = new CsvStream(new SourceURL(this.file));
        stream.init();
        this.labels.put(1L, "Intro");
        Data item = stream.read();
        while (item != null) {
            Integer n;
            Integer n2;
            String frame = (String)item.get((Object)"frame");
            String transition = (String)item.get((Object)"transition");
            String label = (String)item.get((Object)"label");
            if (frame != null && transition.equals("C")) {
                this.labels.put(Long.parseLong(frame), label);
                n2 = counterCuts;
                n = counterCuts = Integer.valueOf(counterCuts + 1);
            } else if (frame != null && transition.equals("GT")) {
                this.labels.put(Long.parseLong(frame), label);
                n2 = counterGT;
                n = counterGT = Integer.valueOf(counterGT + 1);
            }
            item = stream.read();
        }
        stream.close();
        super.init(ctx);
        System.out.println("Initalization of AddNewsshowLabels completed. " + this.labels.size() + " elements found (" + counterCuts + " Cuts and " + counterGT + " Gradual Transitions)");
    }

    public Data process(Data input) {
        Long frame = (Long)input.get((Object)"frame:id");
        if (this.labels.containsKey(frame)) {
            input.put((Object)"@label:shotboundary", (Object)true);
            this.lastlabel = this.labels.get(frame) != null ? this.labels.get(frame) : "not definined";
        } else {
            input.put((Object)"@label:shotboundary", (Object)false);
        }
        if (this.lastlabel.equalsIgnoreCase("AS")) {
            input.put((Object)"@label:anchorshot", (Object)true);
        } else {
            input.put((Object)"@label:anchorshot", (Object)false);
        }
        System.out.println(this.lastlabel + "  " + this.lastlabel.equalsIgnoreCase("AS"));
        input.put((Object)"@label:shottype", (Object)this.lastlabel);
        return input;
    }
}

