/*
 * Decompiled with CFR 0.152.
 */
package stream.news.learner.anchorshotdetection;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class ApplyImageModel
extends AbstractImageProcessor {
    Integer t = 50;
    ImageRGB modelImage = new ImageRGB(0, 0);
    String model = "C:/Users/Matthias/Documents/SchulteSVN/Diplomarbeit/data/anchorshots/2-scaled.jpg";
    String predictionkey = "@prediction:anchorshot";

    @Parameter(description="Tells the processor, where to find the model to be matched.")
    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    @Parameter(description="Sets the threshold t to a new value.")
    public void setT(Integer t) {
        this.t = t;
    }

    public Integer getT() {
        return this.t;
    }

    @Parameter(description="Sets the key under which the classifier shall store the predicted label.")
    public void setPredictionkey(String predictionkey) {
        this.predictionkey = predictionkey;
    }

    public String getPredictionkey() {
        return this.predictionkey;
    }

    public void init(ProcessContext ctx) throws Exception {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.model));
        BufferedImage temp = ImageIO.read(is);
        this.modelImage = new ImageRGB(temp);
        super.init(ctx);
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        int pixels = 0;
        double similar = 0.0;
        for (int i = 0; i < this.modelImage.getWidth(); ++i) {
            for (int j = 0; j < this.modelImage.getHeight(); ++j) {
                int rgbmodel = this.modelImage.getRGB(i, j);
                int rold = rgbmodel >> 16 & 0xFF;
                int gold = rgbmodel >> 8 & 0xFF;
                int bold = rgbmodel & 0xFF;
                if (rold >= 250 || gold >= 250 || bold >= 250) continue;
                int rgboriginal = img.getRGB(i, j);
                int rnew = rgboriginal >> 16 & 0xFF;
                int gnew = rgboriginal >> 8 & 0xFF;
                int bnew = rgboriginal & 0xFF;
                int rdiff = Math.abs(rold - rnew);
                int gdiff = Math.abs(gold - gnew);
                int bdiff = Math.abs(bold - bnew);
                ++pixels;
                if (rdiff >= 55 || gdiff >= 55 || bdiff >= 55) continue;
                similar += 1.0;
            }
        }
        double similarityratio = similar / (double)pixels;
        item.put((Object)"frame:similaritytoanchorshotmodel", (Object)similarityratio);
        if (similarityratio > 0.5) {
            item.put((Object)this.predictionkey, (Object)true);
        } else {
            item.put((Object)this.predictionkey, (Object)false);
        }
        return item;
    }
}

