/*
 * Decompiled with CFR 0.152.
 */
package stream.news.learner.sbdetection;

import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Parameter;

public class GrayThreshold
extends AbstractProcessor {
    Integer t = 50;
    String graykey = "frame:red:avg";
    String predictionkey = "@prediction:shotboundary";

    @Parameter(description="Sets the threshold t.")
    public void setT(Integer t) {
        this.t = t;
    }

    public Integer getT() {
        return this.t;
    }

    @Parameter(description="Tells the GrayThreshold processor, where to find the gray value of the pixels.")
    public void setGraykey(String graykey) {
        this.graykey = graykey;
    }

    public String getGraykey() {
        return this.graykey;
    }

    @Parameter(description="The key, under which the classifier shall store the predicted label.")
    public void setPredictionkey(String predictionkey) {
        this.predictionkey = predictionkey;
    }

    public String getPredictionkey() {
        return this.predictionkey;
    }

    public Data process(Data input) {
        Double gray = (Double)input.get((Object)this.graykey);
        if (gray == null) {
            return input;
        }
        Boolean prediction = false;
        if (gray >= (double)this.t.intValue()) {
            prediction = true;
        }
        input.put((Object)this.predictionkey, (Object)prediction);
        return input;
    }
}

