/*
 * Decompiled with CFR 0.152.
 */
package stream.video;

import java.awt.Point;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.laser.Trapez;
import stream.laser.TrapezCorrection;

public class TrapezoidCorrection
implements TrapezCorrection {
    static Logger log = LoggerFactory.getLogger(TrapezoidCorrection.class);
    public static final Trapez EINHEITS_TRAPEZ = new Trapez(new Point(0, 0), new Point(0, 1), new Point(1, 0), new Point(1, 1));
    RealMatrix A;

    public TrapezoidCorrection() {
        this.A = null;
    }

    public TrapezoidCorrection(RealMatrix a) {
        this.A = a;
    }

    public void setMatrix(RealMatrix a) throws Exception {
        double[][] data = a.getData();
        if (data.length != 2 || data[0].length != 2) {
            throw new Exception("Invalid Matrix-dimensions! Matrix needs to be in 2x2 format!");
        }
        this.A = a;
    }

    @Override
    public Point map(Point x) {
        if (this.A == null) {
            log.info("No matrix defined, returning point AS IS.");
            return new Point(x.x, x.y);
        }
        RealMatrixImpl b = new RealMatrixImpl((double[][])new double[][]{{1.0}, {x.x}, {x.y}, {x.x * x.y}});
        log.info("Point b = {}", (Object)b);
        RealMatrix p = this.A.multiply((RealMatrix)b);
        log.info("   A b = {}", (Object)p);
        Long nx = Math.round(p.getData()[1][0]);
        Long ny = Math.round(p.getData()[2][0]);
        log.info("   mapped to {},{}", (Object)nx, (Object)ny);
        return new Point(nx.intValue(), ny.intValue());
    }

    public Point unmap(Point p) {
        if (this.A == null) {
            log.info("No matrix defined, returning point AS IS.");
            return new Point(p.x, p.y);
        }
        log.info("Point {},{} is", (Object)p.x, (Object)p.y);
        RealMatrixImpl b = new RealMatrixImpl((double[][])new double[][]{{p.x}, {p.y}});
        RealMatrix q = this.A.inverse().multiply((RealMatrix)b);
        Long nx = Math.round(q.getData()[0][0]);
        Long ny = Math.round(q.getData()[1][0]);
        log.info("   mapped to {},{}", (Object)nx, (Object)ny);
        return new Point(nx.intValue(), ny.intValue());
    }

    public static RealMatrix subSetTrapez2matrix(Trapez from) {
        double[][] tf = new double[][]{{1.0, 1.0, 1.0, 1.0}, {from.tl.x, from.bl.x, from.tr.x, from.br.x}, {from.tl.y, from.bl.y, from.tr.y, from.br.y}, {from.tl.x * from.tl.y, from.bl.x * from.bl.y, from.tr.x * from.tr.y, from.br.x * from.br.y}};
        return new RealMatrixImpl((double[][])tf);
    }

    public static void main(String[] args) {
        Trapez g = new Trapez(new Point(0, 0), new Point(0, 1024), new Point(768, 0), new Point(1024, 768));
        Trapez x = new Trapez(new Point(128, 10), new Point(92, 312), new Point(517, 8), new Point(432, 303));
        RealMatrix At = TrapezoidCorrection.compute(x, g);
        log.info("At = {}", (Object)At);
        TrapezoidCorrection tc = new TrapezoidCorrection(At);
        Point p = new Point(128, 10);
        Point q = tc.map(p);
        log.info("{}  ~>  {}", (Object)p, (Object)q);
        p = new Point(92, 312);
        q = tc.map(p);
        log.info("{}  ->  {}", (Object)p, (Object)q);
        p = new Point(432, 303);
        q = tc.map(p);
        log.info("{}  ->  {}", (Object)p, (Object)q);
    }

    public static RealMatrix matrix4x4(Trapez from) {
        double[][] tf = new double[][]{{1.0, 1.0, 1.0, 1.0}, {from.tl.x, from.bl.x, from.tr.x, from.br.x}, {from.tl.y, from.bl.y, from.tr.y, from.br.y}, {from.tl.x * from.tl.y, from.bl.x * from.bl.y, from.tr.x * from.tr.y, from.br.x * from.br.y}};
        return new RealMatrixImpl((double[][])tf);
    }

    public static RealMatrix trapez2matrixT(Trapez from) {
        double[][] tf = new double[][]{{from.tl.x, from.tl.y}, {from.bl.x, from.bl.y}, {from.tr.x, from.tr.y}, {from.br.x, from.br.y}};
        return new RealMatrixImpl((double[][])tf);
    }

    public static RealMatrix compute(Trapez from, Trapez to) {
        RealMatrix X = TrapezoidCorrection.matrix4x4(from);
        RealMatrix G = TrapezoidCorrection.matrix4x4(to);
        RealMatrix XXt_inv = X.multiply(X.transpose()).inverse();
        RealMatrix At = XXt_inv.multiply(X).multiply(G.transpose()).transpose();
        log.info("At = {}", (Object)At);
        return At;
    }
}

