/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class Crop
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(Crop.class);
    String output = "frame:cropped";
    int x = 0;
    int y = 0;
    int width = 10;
    int height = 10;

    public String getOutput() {
        return this.output;
    }

    @Parameter(description="Key/name of the attribute into which the output cropped image is placed, default is 'frame:cropped'.")
    public void setOutput(String output) {
        this.output = output;
    }

    public int getX() {
        return this.x;
    }

    @Parameter(description="x coordinate of the lower-left corder of the rectangle for cropping, defaults to 0.")
    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    @Parameter(description="y coordinate of the lower-left corder of the rectangle for cropping, defaults to 0.")
    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    @Parameter(description="Width of the rectangle to crop, default is 10.")
    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    @Parameter(description="Height of the rectangle to crop, default is 10.")
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        ImageRGB cropped;
        block4: {
            cropped = new ImageRGB(this.width, this.height);
            try {
                for (int i = 0; i < this.width && i + this.x < img.getWidth(); ++i) {
                    for (int j = 0; j < this.height && j + this.y < img.getHeight(); ++j) {
                        cropped.setRGB(i, j, img.getRGB(i + this.x, j + this.y));
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to crop image: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        item.put((Object)this.output, (Object)cropped);
        return item;
    }
}

