/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import java.awt.Color;
import stream.Data;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class Rectangle
extends AbstractImageProcessor {
    String output;
    int x;
    int y;
    int width;
    int height;
    Color color;

    public Rectangle() {
        this.output = this.imageKey;
        this.x = 0;
        this.y = 0;
        this.width = 10;
        this.height = 10;
        this.color = Color.BLACK;
    }

    public String getOutput() {
        return this.output;
    }

    @Parameter(description="Key/name of the attribute into which the output cropped image is placed, default is 'frame:cropped'.")
    public void setOutput(String output) {
        this.output = output;
    }

    public int getX() {
        return this.x;
    }

    @Parameter(description="x coordinate of the lower-left corder of the rectangle for cropping, defaults to 0.")
    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    @Parameter(description="y coordinate of the lower-left corder of the rectangle for cropping, defaults to 0.")
    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    @Parameter(description="Width of the rectangle to crop, default is 10.")
    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    @Parameter(description="Height of the rectangle to crop, default is 10.")
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        int[] orig = img.getPixels();
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int porig = (i + this.y) * img.getWidth() + (j + this.x);
                if (i != 0 && i != this.height && j != 0 && j != this.width) continue;
                orig[porig] = 0;
            }
        }
        item.put((Object)this.output, (Object)new ImageRGB(img.getWidth(), img.getHeight(), orig));
        return item;
    }
}

