/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Context;
import stream.Data;
import stream.annotations.Parameter;
import stream.expressions.ExpressionResolver;

public class BinaryWriter
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(BinaryWriter.class);
    String url = null;
    String currentUrl;
    String key;
    OutputStream output;

    public String getUrl() {
        return this.url;
    }

    @Parameter(description="The URL to write to (file://...).", required=true)
    public void setUrl(String url) {
        this.url = url;
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(description="The key of the attribute containing the byte array to write.", required=true)
    public void setKey(String key) {
        this.key = key;
    }

    public Data process(Data input) {
        try {
            Serializable val = (Serializable)input.get((Object)this.key);
            if (val == null) {
                return input;
            }
            byte[] data = null;
            if (!val.getClass().isArray() && val.getClass().getComponentType() == Byte.TYPE) {
                log.error("Value {} for key {} is not of required type 'byte[]'", (Object)val, (Object)this.key);
                return input;
            }
            data = (byte[])val;
            String newUrl = ExpressionResolver.expand((String)this.url, (Context)this.context, (Data)input);
            if (newUrl.equals(this.currentUrl)) {
                if (this.output == null) {
                    this.output = this.createOutputStream(newUrl);
                    this.currentUrl = newUrl;
                }
            } else {
                if (this.output != null) {
                    this.output.close();
                }
                this.output = this.createOutputStream(newUrl);
                this.currentUrl = newUrl;
            }
            log.debug("Writing {} bytes to {}", (Object)data.length, (Object)this.currentUrl);
            this.output.write(data);
        }
        catch (Exception e) {
            log.error("Failed to write data: {}", (Object)e.getMessage());
        }
        return input;
    }

    private OutputStream createOutputStream(String theUrl) throws Exception {
        File file = new File(theUrl);
        if (theUrl.startsWith("file:")) {
            file = new File(theUrl.substring(5));
        }
        log.debug("Creating new outputstream to file '{}'", (Object)file);
        if (file.isDirectory()) {
            throw new Exception("Cannot write to directory '" + theUrl + "'!");
        }
        if (!file.getParentFile().isDirectory()) {
            file.getParentFile().mkdirs();
        }
        return new FileOutputStream(file);
    }
}

