/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Parameter;
import stream.image.ImageProcessor;
import stream.image.ImageRGB;

public abstract class AbstractImageProcessor
extends AbstractProcessor
implements ImageProcessor {
    static Logger log = LoggerFactory.getLogger(AbstractImageProcessor.class);
    protected String imageKey = "frame:image";

    public String getImage() {
        return this.imageKey;
    }

    @Parameter(description="The name of the attribute that contains the byte array data of the encoded image or the ImageRGB object (if previously been decoded). Default value is: `frame:image`.", required=false)
    public void setImage(String data) {
        this.imageKey = data;
    }

    public Data process(Data input) {
        Serializable value = (Serializable)input.get((Object)this.imageKey);
        if (value instanceof ImageRGB) {
            Data result = this.process(input, (ImageRGB)value);
            return result;
        }
        byte[] bytes = (byte[])input.get((Object)this.imageKey);
        if (bytes == null) {
            return input;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
            if (bufferedImage == null) {
                log.debug("No valid JPEG image!");
                return null;
            }
            ImageRGB img = new ImageRGB(bufferedImage);
            Data result = this.process(input, img);
            return result;
        }
        catch (Exception e) {
            log.error("Error processing image: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return input;
        }
    }

    @Override
    public abstract Data process(Data var1, ImageRGB var2);
}

