/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import stream.Data;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class BorderDetection
extends AbstractImageProcessor {
    String output = "data";
    int tolerance = 0;

    public String getOutput() {
        return this.output;
    }

    @Parameter(description="The name/key of the output image is stored. If this name equals the name of the input image, the input image is going to be overwritten.")
    public void setOutput(String output) {
        this.output = output;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    @Parameter(description="The number of neighboring pixels that may have a different color value, without causing, that the actual pixel becomes recognized as a border pixel. The higher the tolerance is, the less border pixels will be found.")
    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        int x;
        ImageRGB borderimage = new ImageRGB(img.getWidth(), img.getHeight());
        for (x = 0; x < borderimage.getWidth(); ++x) {
            borderimage.setRGB(x, 0, 255, 255, 255);
            borderimage.setRGB(x, borderimage.getHeight() - 1, 255, 255, 255);
        }
        for (int y = 1; y < borderimage.getHeight() - 1; ++y) {
            borderimage.setRGB(0, y, 255, 255, 255);
            borderimage.setRGB(borderimage.getWidth() - 1, y, 255, 255, 255);
        }
        for (x = 1; x < img.getWidth() - 1; ++x) {
            for (int y = 1; y < img.getHeight() - 1; ++y) {
                int sameneighbors = 0;
                if (img.getRGB(x, y) == img.getRGB(x - 1, y)) {
                    ++sameneighbors;
                }
                if (img.getRGB(x, y) == img.getRGB(x + 1, y)) {
                    ++sameneighbors;
                }
                if (img.getRGB(x, y) == img.getRGB(x, y - 1)) {
                    ++sameneighbors;
                }
                if (img.getRGB(x, y) == img.getRGB(x, y + 1)) {
                    ++sameneighbors;
                }
                if (sameneighbors >= 4 - this.tolerance) {
                    borderimage.setRGB(x, y, 255, 255, 255);
                    continue;
                }
                borderimage.setRGB(x, y, 0, 0, 0);
            }
        }
        item.put((Object)this.output, (Object)borderimage);
        return item;
    }
}

