/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.annotations.Parameter;
import stream.image.ImageRGB;

public class CreateRGBImage
implements Processor {
    static Logger log = LoggerFactory.getLogger(CreateRGBImage.class);
    String key = "image";
    String from = "data";

    public Data process(Data input) {
        block2: {
            try {
                byte[] data = (byte[])input.get((Object)this.from);
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(data));
                ImageRGB image = new ImageRGB(img);
                input.put((Object)this.key, (Object)image);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
        return input;
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(description="The name/key of the attribute to which the RGBImage object is being output, defaults to `image`.")
    public void setKey(String key) {
        this.key = key;
    }

    public String getFrom() {
        return this.from;
    }

    @Parameter(description="The name/key of the attribute which holds a byte array of the image data, defaults to `data`.")
    public void setFrom(String from) {
        this.from = from;
    }
}

