/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;
import stream.image.ImageRGB;

public class DisplayImage
extends AbstractProcessor
implements WindowListener {
    static Logger log = LoggerFactory.getLogger(DisplayImage.class);
    final JFrame frame;
    final JPanel buttons = new JPanel(new FlowLayout(0));
    final ImagePanel imagePanel;
    final JLabel info = new JLabel();
    final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss dd-MM-yyyy");
    String key = "frame:data";
    boolean onTop = true;
    boolean initialSize = false;
    String timestamp = "@timestamp";
    String onClose = "";
    boolean closing = false;
    AtomicBoolean stopped = new AtomicBoolean(false);
    long id = 0L;

    public DisplayImage() {
        this.frame = new JFrame();
        this.frame.setSize(640, 384);
        this.frame.getContentPane().setLayout(new BorderLayout());
        final JButton play = new JButton("start/stop");
        play.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                AtomicBoolean atomicBoolean = DisplayImage.this.stopped;
                synchronized (atomicBoolean) {
                    boolean val = DisplayImage.this.stopped.get();
                    DisplayImage.this.stopped.set(!val);
                    DisplayImage.this.stopped.notifyAll();
                }
                if (DisplayImage.this.stopped.get()) {
                    play.setText("Start");
                } else {
                    play.setText("Stop");
                }
            }
        });
        this.buttons.add(play);
        this.frame.getContentPane().add((Component)this.buttons, "North");
        this.imagePanel = new ImagePanel();
        this.frame.getContentPane().add((Component)this.imagePanel, "Center");
        this.frame.getContentPane().add((Component)this.info, "South");
        this.frame.addWindowListener(this);
        this.imagePanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                int x = e.getX();
                int y = e.getY();
                if (DisplayImage.this.imagePanel.frame != null) {
                    int rgb = DisplayImage.this.imagePanel.frame.getRGB(x, y);
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    DisplayImage.this.info.setText("x: " + x + ", y: " + y + ", RGB = (" + red + " / " + green + " / " + blue + ")");
                } else {
                    DisplayImage.this.info.setText("x: " + x + ", y: " + y);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data process(Data input) {
        if (this.closing) {
            return input;
        }
        Serializable val = (Serializable)input.get((Object)this.key);
        if (val == null) {
            log.error("No image for key '{}' found!", (Object)this.key);
            return input;
        }
        BufferedImage image = null;
        if (val instanceof ImageRGB) {
            log.debug("Found image already as image object!");
            image = ((ImageRGB)val).createImage();
        }
        if (val.getClass().isArray() && val.getClass().getComponentType() == Byte.TYPE) {
            try {
                log.debug("creating image from bytes");
                image = ImageIO.read(new ByteArrayInputStream((byte[])val));
            }
            catch (Exception e) {
                log.error("Failed to read image from byte array: {}", (Object)e.getMessage());
                return input;
            }
        }
        if (image != null) {
            Long time = null;
            try {
                if (this.timestamp != null) {
                    time = new Long(((Serializable)input.get((Object)this.timestamp)).toString());
                }
            }
            catch (Exception e) {
                time = null;
            }
            if (this.id++ % 3L == 0L) {
                this.imagePanel.setFrame(image, null);
                if (time != null) {
                    this.info.setText(this.timeFormat.format(new Date(time)));
                }
                this.frame.repaint();
                this.frame.validate();
                if (!this.initialSize) {
                    this.frame.pack();
                    this.initialSize = true;
                }
            }
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
        }
        while (this.stopped.get()) {
            AtomicBoolean atomicBoolean = this.stopped;
            synchronized (atomicBoolean) {
                try {
                    this.stopped.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return input;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        if (this.onTop) {
            this.frame.setAlwaysOnTop(true);
        }
        this.frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws Exception {
        super.finish();
        AtomicBoolean atomicBoolean = this.stopped;
        synchronized (atomicBoolean) {
            this.stopped.set(false);
            this.frame.setVisible(false);
        }
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(description="The name/key of the attribute containing the RGB image object, defaults to `image`.")
    public void setImage(String img) {
        this.key = img;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isOnTop() {
        return this.onTop;
    }

    public void setOnTop(boolean onTop) {
        this.onTop = onTop;
    }

    public String getOnClose() {
        return this.onClose;
    }

    @Parameter(description="If set to `shutdown`, closing the window will shutdown the JVM (ie. the process container).")
    public void setOnClose(String onClose) {
        this.onClose = onClose;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closing = true;
        log.info("windowClosing: {}", (Object)e);
        if ("shutdown".equalsIgnoreCase(this.onClose)) {
            log.info("Shutting down the container...");
            System.exit(0);
        } else {
            log.info("Window closed.");
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        log.info("windowClosed: {}", (Object)e);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 3182958661267766150L;
        final SimpleDateFormat fmt = new SimpleDateFormat("hh:mm:ss dd-MM-yyyy");
        BufferedImage frame = null;
        Long timestamp = null;

        public ImagePanel() {
            this.setBackground(Color.WHITE);
        }

        @Override
        public void paint(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint(g);
            int offx = 0;
            int offy = 0;
            if (this.frame != null) {
                offx = Math.abs((this.frame.getWidth() - this.getWidth()) / 2);
                offy = Math.abs((this.frame.getHeight() - this.getHeight()) / 2);
                g.drawImage(this.frame, offx, offy, null);
            }
            if (this.timestamp != null) {
                g.setColor(Color.WHITE);
                g.drawString(this.fmt.format(new Date(this.timestamp)), 4 + offx, 20 + offy);
            }
        }

        public void setFrame(BufferedImage frame, Long timestamp) {
            this.timestamp = timestamp;
            this.frame = frame;
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            if (this.frame == null) {
                return new Dimension(320, 240);
            }
            return new Dimension(this.frame.getWidth(), this.frame.getHeight());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }
    }
}

