/*
 * Decompiled with CFR 0.152.
 */
package stream.image.features;

import stream.Data;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class CenterOfMass
extends AbstractImageProcessor {
    String colorchannel = "red";
    Boolean normalized = true;

    @Parameter(description="Sets the color channel, on which the Center of Mass computation is based on.")
    public void setColorchannel(String colorchannel) {
        this.colorchannel = colorchannel;
    }

    public String getColorchannel() {
        return this.colorchannel;
    }

    @Parameter(description="Sets, if the processor computes the normalized Center of Mass or the absolute Center of Mass")
    public void setNormalized(Boolean normalized) {
        this.normalized = normalized;
    }

    public Boolean getNormalized() {
        return this.normalized;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        int sumofallpixels = 0;
        int[] rowsums = new int[img.getWidth()];
        for (int i = 0; i < img.getWidth(); ++i) {
            rowsums[i] = 0;
            for (int j = 0; j < img.getHeight(); ++j) {
                int gray;
                int blue;
                int green;
                int red;
                if (this.colorchannel.equalsIgnoreCase("red")) {
                    int n = i;
                    rowsums[n] = rowsums[n] + img.getRED(i, j);
                    sumofallpixels += img.getRED(i, j);
                } else if (this.colorchannel.equalsIgnoreCase("green")) {
                    int n = i;
                    rowsums[n] = rowsums[n] + img.getGREEN(i, j);
                    sumofallpixels += img.getGREEN(i, j);
                } else if (this.colorchannel.equalsIgnoreCase("blue")) {
                    int n = i;
                    rowsums[n] = rowsums[n] + img.getBLUE(i, j);
                    sumofallpixels += img.getBLUE(i, j);
                } else if (this.colorchannel.equalsIgnoreCase("gray")) {
                    red = img.getRED(i, j);
                    green = img.getGREEN(i, j);
                    blue = img.getBLUE(i, j);
                    gray = Math.round(0 * red + 0 * green + 0 + blue);
                    int n = i;
                    rowsums[n] = rowsums[n] + gray;
                    sumofallpixels += gray;
                }
                if (!this.colorchannel.equalsIgnoreCase("black_and_white") || (gray = Math.round(0 * (red = img.getRED(i, j)) + 0 * (green = img.getGREEN(i, j)) + 0 + (blue = img.getBLUE(i, j)))) <= 125) continue;
                int n = i;
                rowsums[n] = rowsums[n] + gray;
                sumofallpixels += gray;
            }
        }
        int valuetosearchfor = sumofallpixels / 2;
        int sum = 0;
        int x = 0;
        while (sum < valuetosearchfor) {
            sum += rowsums[x];
            ++x;
        }
        if (this.normalized.booleanValue()) {
            double normalizedxcenterofmass = (double)x / (double)img.getWidth();
            item.put((Object)("frame:" + this.colorchannel + ":CenterOfMass:normalizedX"), (Object)normalizedxcenterofmass);
        } else {
            item.put((Object)("frame:" + this.colorchannel + ":CenterOfMass:X"), (Object)x);
        }
        int[] columnsum = new int[img.getHeight()];
        for (int j = 0; j < img.getHeight(); ++j) {
            columnsum[j] = 0;
            for (int i = 0; i < img.getWidth(); ++i) {
                int gray;
                int blue;
                int green;
                int red;
                if (this.colorchannel.equalsIgnoreCase("red")) {
                    int n = j;
                    columnsum[n] = columnsum[n] + img.getRED(i, j);
                    continue;
                }
                if (this.colorchannel.equalsIgnoreCase("green")) {
                    int n = j;
                    columnsum[n] = columnsum[n] + img.getGREEN(i, j);
                    continue;
                }
                if (this.colorchannel.equalsIgnoreCase("blue")) {
                    int n = j;
                    columnsum[n] = columnsum[n] + img.getBLUE(i, j);
                    continue;
                }
                if (this.colorchannel.equalsIgnoreCase("gray")) {
                    red = img.getRED(i, j);
                    green = img.getGREEN(i, j);
                    blue = img.getBLUE(i, j);
                    gray = Math.round(0 * red + 0 * green + 0 + blue);
                    int n = j;
                    columnsum[n] = columnsum[n] + gray;
                    continue;
                }
                if (!this.colorchannel.equalsIgnoreCase("black_and_white") || (gray = Math.round(0 * (red = img.getRED(i, j)) + 0 * (green = img.getGREEN(i, j)) + 0 + (blue = img.getBLUE(i, j)))) <= 125) continue;
                int n = j;
                columnsum[n] = columnsum[n] + gray;
            }
        }
        sum = 0;
        int y = 0;
        while (sum < valuetosearchfor) {
            sum += columnsum[y];
            ++y;
        }
        if (this.normalized.booleanValue()) {
            double normalizedycenterofmass = (double)y / (double)img.getHeight();
            item.put((Object)("frame:" + this.colorchannel + ":CenterOfMass:normalizedY"), (Object)normalizedycenterofmass);
        } else {
            item.put((Object)("frame:" + this.colorchannel + ":CenterOfMass:Y"), (Object)y);
        }
        return item;
    }
}

