/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.flow.Emitter;
import stream.io.Ffmpeg;
import stream.io.MJpegImageStream;
import stream.io.Sink;
import stream.io.SourceURL;
import stream.io.WavStream;

public class DecodeVideo
extends Emitter {
    static Logger log = LoggerFactory.getLogger(DecodeVideo.class);
    String key = "packet:data";
    ByteArrayOutputStream chunks = new ByteArrayOutputStream();
    int chunksWritten = 0;
    Long frameId = 0L;

    public Data processMatchingData(Data input) {
        Serializable value = (Serializable)input.get((Object)this.key);
        if (value != null && value.getClass().isArray() && value.getClass().getComponentType() == Byte.TYPE) {
            byte[] data = (byte[])value;
            int pid = (Integer)input.get((Object)"packet:pid");
            if (pid == 0 && this.chunksWritten > 0) {
                log.info("{} chunks in memory, flushing and decoding...", (Object)this.chunksWritten);
                try {
                    File video = File.createTempFile("video", ".ts");
                    FileOutputStream fos = new FileOutputStream(video);
                    fos.write(this.chunks.toByteArray());
                    fos.close();
                    log.info("Wrote video chunk to {}", (Object)video);
                    this.chunks = new ByteArrayOutputStream();
                    this.chunksWritten = 0;
                    File tempData = File.createTempFile("decoded-frames", ".mjpeg");
                    String ffmpeg = Ffmpeg.getBinary();
                    String cmd = ffmpeg + " -v quiet -y -i " + video.getAbsolutePath() + " -vcodec mjpeg -s 384x216 " + tempData.getAbsolutePath();
                    log.info("Calling  '{}'", (Object)cmd);
                    Process p = Runtime.getRuntime().exec(cmd);
                    this.dump(p.getErrorStream());
                    int ret = p.waitFor();
                    log.info("Process exited with code {}.", (Object)ret);
                    File wavData = File.createTempFile("wav-samples", ".wav");
                    cmd = ffmpeg + " -v quiet -y -i " + video.getAbsolutePath() + " -acodec pcm_u8 " + wavData.getAbsolutePath();
                    log.info("Calling  '{}'", (Object)cmd);
                    p = Runtime.getRuntime().exec(cmd);
                    this.dump(p.getErrorStream());
                    MJpegImageStream frames = new MJpegImageStream(new FileInputStream(tempData));
                    frames.init();
                    WavStream samples = new WavStream(new SourceURL("file:" + wavData.getAbsolutePath()));
                    samples.setBlockSize(1920);
                    samples.init();
                    Data frame = frames.read();
                    while (frame != null) {
                        Long l = this.frameId;
                        Long l2 = this.frameId = Long.valueOf(this.frameId + 1L);
                        frame.put((Object)"frame:id", (Object)l);
                        frame.put((Object)"frame:time", (Object)(this.frameId.doubleValue() * 0.04));
                        Data audio = samples.read();
                        if (audio != null) {
                            frame.putAll((Map)audio);
                        }
                        this.emit(frame);
                        frame = frames.read();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.chunks.write(data);
                    ++this.chunksWritten;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return input;
    }

    public void setOutput(Sink[] sink) {
        this.setSinks(sink);
    }

    public Sink[] getOutput() {
        return this.sinks;
    }

    public void dump(InputStream in) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (line != null) {
            System.out.println(line);
            line = reader.readLine();
        }
        reader.close();
    }
}

