/*
 * Decompiled with CFR 0.152.
 */
package stream.video;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;

public class Framerate
implements Processor {
    static Logger log = LoggerFactory.getLogger(Framerate.class);
    String frame = "frame:image";
    Long first = 0L;
    Long last = 0L;
    Integer count = 0;
    Float fps = Float.valueOf(25.0f);
    int frametime = 40;

    public Float getFps() {
        return this.fps;
    }

    public void setFps(Float fps) {
        this.fps = fps;
        if (fps.floatValue() > 0.0f) {
            Double frameTime = 1000.0 / (double)fps.floatValue();
            this.frametime = frameTime.intValue();
        }
    }

    public Data process(Data input) {
        if (this.first == 0L) {
            this.first = System.currentTimeMillis();
        }
        if (input.containsKey((Object)this.frame)) {
            Integer n = this.count;
            Integer n2 = this.count = Integer.valueOf(this.count + 1);
            if (this.last > 0L && (double)this.fps.floatValue() > 0.0) {
                Long dur = (System.currentTimeMillis() - this.first) / 1000L;
                double rate = this.count.doubleValue() / dur.doubleValue();
                log.info("fps: {}", (Object)rate);
                if (rate < (double)this.fps.floatValue()) {
                    log.info("Dropping frame...");
                    this.last = System.currentTimeMillis();
                    return null;
                }
                long ago = System.currentTimeMillis() - this.last;
                Long delay = (long)this.frametime - ago;
                log.info("Last frame was {} ms ago, waiting for {} ms", (Object)ago, (Object)delay);
                if (delay > 0L) {
                    this.sleep(delay);
                }
                Double time = (double)(System.currentTimeMillis() - this.first) / 1000.0;
                if (this.count % 10 == 0) {
                    log.info("Video position is: {} (calculated: {})", (Object)time, (Object)((double)(this.count * this.frametime) / 1000.0));
                }
            } else {
                log.info("last = {}, fps = {}, just running...", (Object)this.last, (Object)this.fps);
            }
            this.last = System.currentTimeMillis();
        }
        return input;
    }

    public void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

