/*
 * Decompiled with CFR 0.152.
 */
package stream.audio;

import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;

public class PlayWavData
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(PlayWavData.class);
    static final int AUDIO_BUFFER = 131072;
    AudioFormat header;
    SourceDataLine audio;
    Double volume = 0.5;
    Integer blocksProcessed = 0;
    Long samplesWritten = 0L;
    ByteBuffer buffer = ByteBuffer.allocate(49152);

    public Double getVolume() {
        return this.volume;
    }

    public void setVolume(Double volume) {
        if (volume > 1.0) {
            this.volume = 1.0;
            return;
        }
        if (volume < 0.0) {
            this.volume = 0.0;
            return;
        }
        this.volume = volume;
    }

    public Data process(Data input) {
        Integer channels;
        Number sampleRate;
        if (this.header == null && input.containsKey((Object)"wav:samplerate")) {
            sampleRate = new Long(input.get((Object)"wav:samplerate") + "");
            channels = new Integer(input.get((Object)"wav:channels") + "");
            Integer bytesPerSample = new Integer(input.get((Object)"wav:bytesPerSample") + "");
            this.header = new AudioFormat(((Long)sampleRate).floatValue(), 8 * bytesPerSample, channels, true, false);
            log.info("Initializing audio output...");
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.header);
            try {
                log.info("Acquiring audio-line from AudioSystem...");
                this.audio = (SourceDataLine)AudioSystem.getLine(info);
                log.info("Opening audio-line...");
                this.audio.open(this.header, 131072);
            }
            catch (LineUnavailableException e) {
                log.error("Unable to acquire audio-line: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
            log.debug("Starting audio-device...");
            this.audio.start();
        }
        if (this.header != null) {
            sampleRate = this.blocksProcessed;
            channels = this.blocksProcessed = Integer.valueOf(this.blocksProcessed + 1);
            double[] samples = (double[])input.get((Object)"wav:samples");
            byte[] bytes = new byte[samples.length];
            for (int i = 0; i < samples.length; ++i) {
                bytes[i] = (byte)(this.volume * samples[i]);
            }
            if (this.buffer.remaining() > bytes.length) {
                log.info("Adding {} bytes to buffer", (Object)bytes.length);
                this.buffer.put(bytes);
                return input;
            }
            this.buffer.flip();
            log.info("Writing {} bytes to audio-line...", (Object)this.buffer.limit());
            this.audio.write(this.buffer.array(), 0, this.buffer.limit());
            this.samplesWritten = this.samplesWritten + (long)this.buffer.limit();
            this.buffer.clear();
            this.buffer.put(bytes);
        } else {
            log.error("No audio-header information received, yet.");
        }
        return input;
    }

    public void finish() throws Exception {
        super.finish();
        if (this.audio != null) {
            if (this.audio.isRunning()) {
                this.audio.stop();
            }
            this.audio.close();
        }
    }
}

