/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class ColorDiscretization
extends AbstractImageProcessor {
    String output = "data";
    Integer valuesPerChannel = 4;
    private Integer[] borders;

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.borders = new Integer[this.valuesPerChannel.intValue()];
        for (int i = 0; i < this.valuesPerChannel; ++i) {
            this.borders[i] = 255 / this.valuesPerChannel * i;
        }
    }

    public String getOutput() {
        return this.output;
    }

    @Parameter(description="The name/key under which the output image is stored. If this name equals the name of the input image, the input image is going to be overwritten.")
    public void setOutput(String output) {
        this.output = output;
    }

    public Integer getQuantilesPerChannel() {
        return this.valuesPerChannel;
    }

    @Parameter(description="Set the number of discrete color values, each channel in divided into.")
    public void setBins(Integer bins) {
        this.valuesPerChannel = bins;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        ImageRGB discretizedImage = new ImageRGB(img.getWidth(), img.getHeight());
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int red = img.getRED(x, y);
                int i = 1;
                while (i < this.valuesPerChannel) {
                    if (red < this.borders[i]) {
                        red = this.borders[i - 1] + (this.borders[i] - this.borders[i - 1]) / 2;
                        i = this.valuesPerChannel;
                        continue;
                    }
                    ++i;
                }
                discretizedImage.setRED(x, y, red);
                int green = img.getGREEN(x, y);
                i = 1;
                while (i < this.valuesPerChannel) {
                    if (green < this.borders[i]) {
                        green = this.borders[i - 1] + (this.borders[i] - this.borders[i - 1]) / 2;
                        i = this.valuesPerChannel;
                        continue;
                    }
                    ++i;
                }
                discretizedImage.setGREEN(x, y, green);
                int blue = img.getBLUE(x, y);
                i = 1;
                while (i < this.valuesPerChannel) {
                    if (blue < this.borders[i]) {
                        blue = this.borders[i - 1] + (this.borders[i] - this.borders[i - 1]) / 2;
                        i = this.valuesPerChannel;
                        continue;
                    }
                    ++i;
                }
                discretizedImage.setBLUE(x, y, blue);
            }
        }
        item.put((Object)this.output, (Object)discretizedImage);
        return item;
    }
}

