/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import stream.Data;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class DiffImage
extends AbstractImageProcessor {
    ImageRGB lastImage = null;
    String output = "frame:image";
    Integer threshold = 20;

    @Parameter(description="The name/key under which the output image is stored. If this name equals the name of the input image, the input image is going to be overwritten.")
    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        int i;
        ImageRGB diffImage = new ImageRGB(img.width, img.height);
        for (i = 0; i < diffImage.pixels.length; ++i) {
            diffImage.pixels[i] = img.pixels[i];
        }
        if (this.lastImage == null) {
            this.lastImage = img;
        }
        for (i = 0; i < this.lastImage.pixels.length; ++i) {
            int rgbold = this.lastImage.pixels[i];
            int rgbnew = diffImage.pixels[i];
            int rold = rgbold >> 16 & 0xFF;
            int gold = rgbold >> 8 & 0xFF;
            int bold = rgbold & 0xFF;
            int rnew = rgbnew >> 16 & 0xFF;
            int gnew = rgbnew >> 8 & 0xFF;
            int bnew = rgbnew & 0xFF;
            int rdiff = Math.abs(rold - rnew);
            int gdiff = Math.abs(gold - gnew);
            int bdiff = Math.abs(bold - bnew);
            if (rdiff < this.threshold) {
                rdiff = 0;
            }
            if (gdiff < this.threshold) {
                gdiff = 0;
            }
            if (bdiff < this.threshold) {
                bdiff = 0;
            }
            int rgbdiff = rdiff;
            rgbdiff = (rgbdiff << 8) + gdiff;
            diffImage.pixels[i] = rgbdiff = (rgbdiff << 8) + bdiff;
        }
        this.lastImage = img;
        item.put((Object)this.output, (Object)diffImage);
        return item;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }
}

