/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class PixelChangeRate
extends AbstractImageProcessor {
    ImageRGB last = null;
    Integer threshold = 0;

    @Override
    public Data process(Data item, ImageRGB img) {
        if (this.last == null) {
            this.last = img;
        }
        Integer total = this.last.pixels.length;
        Integer differ = 0;
        int min = 255;
        int max = 0;
        for (int i = 0; i < this.last.pixels.length; ++i) {
            int rgbold = this.last.pixels[i];
            int rgbnew = img.pixels[i];
            int rold = rgbold >> 16 & 0xFF;
            int gold = rgbold >> 8 & 0xFF;
            int bold = rgbold & 0xFF;
            int rnew = rgbnew >> 16 & 0xFF;
            int gnew = rgbnew >> 8 & 0xFF;
            int bnew = rgbnew & 0xFF;
            int rdiff = Math.abs(rold - rnew);
            int gdiff = Math.abs(gold - gnew);
            int bdiff = Math.abs(bold - bnew);
            int rgbdiff = rdiff;
            rgbdiff = (rgbdiff << 8) + gdiff;
            rgbdiff = (rgbdiff << 8) + bdiff;
            int diff = rdiff + gdiff + bdiff;
            if (diff > this.threshold) {
                Integer n = differ;
                Integer n2 = differ = Integer.valueOf(differ + 1);
            }
            min = Math.min(min, diff);
            max = Math.max(max, diff);
        }
        item.put((Object)"frame:pixels:changed", (Object)(differ.doubleValue() / total.doubleValue()));
        item.put((Object)"frame:pixels:minDiff", (Object)min);
        item.put((Object)"frame:pixels:maxDiff", (Object)max);
        return item;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }
}

