/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ByteBufferStream {
    public static final byte[] JPEG_SOI = new byte[]{-1, -40};
    public static final byte[] JPEG_EOI = new byte[]{-1, -39};
    static final ArrayList<byte[]> chunks = new ArrayList();
    final InputStream in;
    final int readBufferSize;
    final byte[] buf;
    final ByteBuffer current;
    final byte[] startSignature;
    final boolean continuous;
    boolean verbose = false;
    Long frames = 0L;
    long begin = 0L;
    long total = 0L;
    boolean closed = false;

    public ByteBufferStream(InputStream in, int readBufferSize, int maxResultBuffer, byte[] startSig, boolean continuous) {
        this.in = in;
        this.readBufferSize = readBufferSize;
        this.buf = new byte[readBufferSize];
        this.startSignature = startSig;
        this.current = ByteBuffer.allocateDirect(maxResultBuffer);
        if (readBufferSize > maxResultBuffer) {
            throw new RuntimeException("Result buffer cannot be smaller than read-buffer!");
        }
        this.continuous = continuous;
    }

    public long getBytesRead() {
        return this.total;
    }

    public byte[] readNextChunk() throws IOException {
        if (this.begin == 0L) {
            this.begin = System.currentTimeMillis();
        }
        int read = 0;
        while (true) {
            if (this.in.available() == 0 && this.continuous) {
                try {
                    if (this.closed) {
                        return null;
                    }
                    Thread.sleep(5L);
                }
                catch (Exception e) {}
                continue;
            }
            read = this.in.read(this.buf);
            if (read < 0 && !this.continuous) {
                return null;
            }
            this.total += (long)read;
            int idx = ByteBufferStream.indexOf(this.buf, JPEG_EOI, 0);
            int offset = 0;
            if (idx >= 0) {
                System.err.println("Found EOI byte-signature at " + (this.total + (long)idx));
                offset = idx;
                if (offset > 0) {
                    this.current.put(this.buf, 0, offset);
                }
                byte[] img = new byte[this.current.position()];
                this.current.flip();
                this.current.get(img);
                Long l = this.frames;
                Long l2 = this.frames = Long.valueOf(this.frames + 1L);
                this.current.clear();
                this.current.put(this.buf, offset, read - offset);
                return img;
            }
            if (this.current.remaining() < this.buf.length) {
                System.err.println("No start found, buffer full, clearing buffer and starting anew");
                this.current.clear();
            }
            this.current.put(this.buf, 0, read);
            if (read < 0) break;
        }
        System.err.println(this.total + " bytes written, last read was: " + read);
        System.out.println("Returning remaining buffer content as last chunk...");
        byte[] img = new byte[this.current.limit()];
        this.current.flip();
        this.current.get(img);
        return img;
    }

    public void close() {
        this.closed = true;
    }

    protected static boolean isSignatureAt(byte[] buffer, int pos, byte[] sig) {
        for (int i = 0; i < sig.length; ++i) {
            byte b = buffer[pos + i];
            if (b == sig[i]) continue;
            return false;
        }
        return true;
    }

    protected static int indexOf(byte[] buffer, byte[] sig, int from) {
        int pos = from;
        while (pos + sig.length < buffer.length && !ByteBufferStream.isSignatureAt(buffer, pos, sig)) {
            ++pos;
        }
        if (pos + sig.length >= buffer.length) {
            return -1;
        }
        return pos;
    }
}

