/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Context;
import stream.Data;
import stream.annotations.Parameter;
import stream.expressions.ExpressionResolver;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class JPEGWriter
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(JPEGWriter.class);
    String output;

    public String getFile() {
        return this.output;
    }

    @Parameter(description="This parameter allows for specifying the output format, allows to specify a runtime expression.", required=true)
    public void setFile(String output) {
        this.output = output;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        block4: {
            if (this.output == null) {
                log.debug("No output property set, skipping item.");
                return item;
            }
            BufferedImage bi = img.createImage();
            String out = ExpressionResolver.expand((String)this.output, (Context)this.context, (Data)item);
            try {
                log.info("Writing JPG image to {}", (Object)out);
                File file = new File(out);
                if (file.getParentFile() != null && !file.getParentFile().isDirectory()) {
                    file.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                ImageIO.write((RenderedImage)bi, "JPG", fos);
                fos.close();
            }
            catch (Exception e) {
                log.error("Failed to write image to {}: {}", (Object)out, (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        return item;
    }
}

