/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingByteBuffer {
    static Logger log = LoggerFactory.getLogger(RingByteBuffer.class);
    final byte[] buffer;
    final int bufferLength;
    int pos = 0;
    int limit = 0;
    long bytesRead = 0L;

    public RingByteBuffer(int size) {
        this.buffer = new byte[size];
        this.bufferLength = this.buffer.length;
    }

    public int getRemaining() {
        return this.bufferLength - (this.limit - this.pos);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public byte getByte(int i) {
        return this.buffer[(this.pos + i) % this.bufferLength];
    }

    public synchronized long read(InputStream in) throws Exception {
        log.info("Reading into buffer, current position: {}, current limit: {}", (Object)this.pos, (Object)this.limit);
        this.bytesRead = 0L;
        int data = -1;
        do {
            if ((data = in.read()) < 0) continue;
            this.buffer[this.limit % this.bufferLength] = (byte)data;
            log.debug("next read returned {}", (Object)this.buffer[this.limit % this.bufferLength]);
            ++this.bytesRead;
            ++this.limit;
            if (this.limit % this.buffer.length == this.pos % this.buffer.length) {
                ++this.pos;
                log.debug("Advancing 'pos' to {}", (Object)this.pos);
            }
            log.debug("pos: {}, limit: {}", (Object)this.pos, (Object)this.limit);
        } while (data >= 0);
        return this.bytesRead;
    }

    public synchronized int append(byte[] data) throws IOException {
        return -1;
    }

    public synchronized int find(byte[] signature, int offset) {
        for (int i = offset; i < this.limit - signature.length; ++i) {
            int idx = RingByteBuffer.containsAt(this.buffer, i, signature);
            if (idx < 0) continue;
            return idx;
        }
        return -1;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    protected int checkBytes(int pos, byte[] sig) {
        for (int s = pos; s < this.limit; ++s) {
            int correct = 0;
            for (int i = 0; i < sig.length && s + i < this.limit; ++i) {
                if (this.buffer[i % this.bufferLength] == sig[i]) {
                    ++correct;
                    continue;
                }
                return -1;
            }
            if (correct != sig.length) continue;
            return s;
        }
        int checked = 0;
        for (int s = pos; s < this.limit; ++s) {
            checked = 0;
            for (int p = 0; p < sig.length; ++p) {
                if (this.buffer[(s + p) % this.buffer.length] != sig[p]) {
                    return -1;
                }
                ++checked;
            }
        }
        if (checked == 0) {
            log.info("signature not found.");
            return -1;
        }
        log.info("Found signature {} at position {}", (Object)new String(sig), (Object)pos);
        return pos;
    }

    public static int containsAt(byte[] buffer, int off, byte[] sig) {
        for (int i = 0; i < sig.length; ++i) {
            if (buffer[(off + i) % buffer.length] == sig[i]) continue;
            return -1;
        }
        return off;
    }

    public static void main(String[] args) throws Exception {
        try {
            byte[] sig = "ab".getBytes();
            RingByteBuffer buf = new RingByteBuffer(1024);
            log.info("Buffer position is {}, limit is {}", (Object)buf.pos, (Object)buf.limit);
            int start = 0;
            int idx = buf.find(sig, start);
            for (int cnt = 0; idx < 0 && cnt < 5; ++cnt) {
                long read = buf.read(RingByteBuffer.createStream("bcbbacbcccadba"));
                if (read < 0L) {
                    log.error("end of stream!");
                    break;
                }
                idx = buf.find(sig, start);
            }
            if (idx >= 0) {
                log.info("Found signature at {}", (Object)idx);
            } else {
                log.info("Signature not found!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getHex(byte[] bytes, int len) {
        return RingByteBuffer.getHex(bytes, 0, len);
    }

    public static String getHex(byte[] bytes, int off, int len) {
        StringBuffer s = new StringBuffer("[");
        for (int i = off; i < bytes.length && i < len; ++i) {
            s.append("0x" + Integer.toHexString(bytes[i]));
            if (i + 1 >= bytes.length) continue;
            s.append(", ");
        }
        s.append("]");
        return s.toString();
    }

    public static InputStream createStream(String str) {
        byte[] data = str.getBytes();
        log.info("Reading data '{}'", (Object)RingByteBuffer.getHex(data, data.length));
        return new ByteArrayInputStream(data);
    }
}

