/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiffStream {
    static Logger log = LoggerFactory.getLogger(TiffStream.class);
    public static final byte[] JPEG_SOI = new byte[]{-1, -40};
    public static final byte[] JPEG_EOI = new byte[]{-1, -39};
    public static final byte[] TIF_SOI = new byte[]{73, 73, 42, 0};
    static final ArrayList<byte[]> chunks = new ArrayList();
    final InputStream in;
    final int readBufferSize;
    final byte[] buf;
    final ByteBuffer current;
    final boolean continuous;
    boolean verbose = false;
    Long frames = 0L;
    long begin = 0L;
    long total = 0L;
    boolean closed = false;
    int start = -1;
    int end = -1;
    boolean endOfStream = false;

    public TiffStream(InputStream in, int readBufferSize, int maxResultBuffer, boolean continuous) {
        this.in = in;
        this.readBufferSize = readBufferSize;
        this.buf = new byte[readBufferSize];
        this.current = ByteBuffer.allocateDirect(maxResultBuffer);
        this.current.clear();
        if (readBufferSize > maxResultBuffer) {
            throw new RuntimeException("Result buffer cannot be smaller than read-buffer!");
        }
        this.continuous = continuous;
        log.debug("Stream created.");
    }

    public long getBytesRead() {
        return this.total;
    }

    public byte[] readNextChunk() throws IOException {
        if (this.endOfStream) {
            return null;
        }
        if (this.begin == 0L) {
            this.begin = System.currentTimeMillis();
        }
        int read = 0;
        int off = 0;
        while (this.start < 0 && read >= 0) {
            read = this.readBytes();
            this.start = this.indexOf(JPEG_SOI, off);
        }
        if (this.start < 0) {
            return null;
        }
        off = this.start;
        while (this.end < 0 && read >= 0) {
            read = this.readBytes();
            this.end = this.indexOf(JPEG_EOI, off);
        }
        if (this.end < 0) {
            this.endOfStream = true;
            this.current.flip();
            byte[] img = new byte[this.current.limit()];
            log.debug("hit end-of-file/stream, dumping remaining {} bytes", (Object)this.current.limit());
            this.current.get(img, 0, img.length);
            return img;
        }
        byte[] image = new byte[this.end - this.start + JPEG_EOI.length];
        this.current.flip();
        this.current.position(this.start);
        this.current.get(image, 0, image.length);
        this.current.compact();
        this.start = -1;
        this.end = -1;
        Long l = this.frames;
        Long l2 = this.frames = Long.valueOf(this.frames + 1L);
        if (log.isDebugEnabled() && this.frames % 100L == 0L) {
            Long time = System.currentTimeMillis() - this.begin;
            log.debug("Read {} frames, frame rate is {} fps", (Object)this.frames, (Object)(100.0 / (time.doubleValue() / 1000.0)));
            this.begin = System.currentTimeMillis();
        }
        return image;
    }

    public void close() {
        this.closed = true;
    }

    protected static boolean isSignatureAt(byte[] buffer, int pos, byte[] sig) {
        for (int i = 0; i < sig.length; ++i) {
            byte b = buffer[pos + i];
            if (b == sig[i]) continue;
            return false;
        }
        return true;
    }

    protected static int indexOf(byte[] buffer, byte[] sig, int from) {
        int pos = from;
        while (pos + sig.length < buffer.length && !TiffStream.isSignatureAt(buffer, pos, sig)) {
            ++pos;
        }
        if (pos + sig.length >= buffer.length) {
            return -1;
        }
        return pos;
    }

    protected int indexOf(byte[] sig, int from) {
        int pos = from;
        while (pos + sig.length < this.current.position()) {
            if (this.isSignatureAt(sig, pos)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    protected boolean isSignatureAt(byte[] sig, int pos) {
        for (int i = 0; i < sig.length; ++i) {
            byte b = this.current.get(pos + i);
            if (b == sig[i]) continue;
            return false;
        }
        return true;
    }

    protected int readBytes() throws IOException {
        if (this.current.limit() - this.current.position() == 0) {
            log.info("Buffer full!");
            return 0;
        }
        int read = this.in.read(this.buf, 0, this.buf.length);
        if (read < 0) {
            return -1;
        }
        this.current.put(this.buf, 0, read);
        this.total += (long)read;
        return read;
    }
}

