/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRGB
implements Serializable {
    static Logger log = LoggerFactory.getLogger(ImageRGB.class);
    private static final long serialVersionUID = -2042395350522979787L;
    public final int height;
    public final int width;
    public final int[] pixels;

    public ImageRGB(int width, int height) {
        this.height = height;
        this.width = width;
        this.pixels = new int[height * width];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = 0;
        }
    }

    public ImageRGB(int width, int height, int[] data) {
        this.height = height;
        this.width = width;
        this.pixels = data;
    }

    public ImageRGB(BufferedImage img) {
        int[] px;
        this.height = img.getHeight();
        this.width = img.getWidth();
        try {
            log.trace("creating image of size  {} x {}", (Object)this.width, (Object)this.height);
            px = new int[this.width * this.height];
        }
        catch (Exception e) {
            log.error("Failed to create image of size {}x{}: " + e.getMessage(), (Object)this.width, (Object)this.height);
            px = new int[]{};
        }
        this.pixels = px;
        img.getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
    }

    public int getRGB(int x, int y) {
        int idx = y * this.width + x;
        return this.pixels[idx];
    }

    public int setRGB(int x, int y, int rgba) {
        int idx = y * this.width + x;
        this.pixels[idx] = rgba;
        return this.pixels[idx];
    }

    public int setRGB(int x, int y, int red, int green, int blue) {
        int rgba = red;
        rgba = (rgba << 8) + green;
        rgba = (rgba << 8) + blue;
        return this.setRGB(x, y, rgba);
    }

    public int getRED(int x, int y) {
        int rgb = this.getRGB(x, y);
        int red = rgb >> 16 & 0xFF;
        return red;
    }

    public void setRED(int x, int y, int red) {
        int rgb = this.getRGB(x, y);
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        int rgbnew = red;
        rgbnew = (rgbnew << 8) + green;
        rgbnew = (rgbnew << 8) + blue;
        this.setRGB(x, y, rgbnew);
    }

    public int getGREEN(int x, int y) {
        int rgb = this.getRGB(x, y);
        int green = rgb >> 8 & 0xFF;
        return green;
    }

    public void setGREEN(int x, int y, int green) {
        int rgb = this.getRGB(x, y);
        int red = rgb >> 16 & 0xFF;
        int blue = rgb & 0xFF;
        int rgbnew = red;
        rgbnew = (rgbnew << 8) + green;
        rgbnew = (rgbnew << 8) + blue;
        this.setRGB(x, y, rgbnew);
    }

    public int getBLUE(int x, int y) {
        int rgb = this.getRGB(x, y);
        int blue = rgb & 0xFF;
        return blue;
    }

    public void setBLUE(int x, int y, int blue) {
        int red;
        int rgb = this.getRGB(x, y);
        int green = rgb >> 8 & 0xFF;
        int rgbnew = red = rgb >> 16 & 0xFF;
        rgbnew = (rgbnew << 8) + green;
        rgbnew = (rgbnew << 8) + blue;
        this.setRGB(x, y, rgbnew);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public BufferedImage createImage() {
        BufferedImage buf = new BufferedImage(this.width, this.height, 1);
        buf.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        return buf;
    }
}

