/*
 * Decompiled with CFR 0.152.
 */
package stream.image.features;

import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class AverageRGBRatios
extends AbstractImageProcessor {
    @Override
    public Data process(Data item, ImageRGB img) {
        int width = img.getWidth();
        int height = img.getHeight();
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = img.getRGB(x, y);
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                r += (double)red;
                g += (double)green;
                b += (double)blue;
            }
        }
        int px = width * height;
        item.put((Object)"frame:red:blue", (Object)((r /= (double)px) / (b /= (double)px)));
        item.put((Object)"frame:red:green", (Object)(r / (g /= (double)px)));
        item.put((Object)"frame:green:blue", (Object)(g / b));
        return item;
    }
}

