/*
 * Decompiled with CFR 0.152.
 */
package stream.image.features;

import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class Brightness
extends AbstractImageProcessor {
    Double last = null;

    @Override
    public Data process(Data item, ImageRGB img) {
        Double totalBrightness = 0.0;
        double cnt = img.pixels.length;
        Double max = null;
        Double min = null;
        for (int i = 0; i < img.pixels.length; ++i) {
            int argb = img.pixels[i];
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            double bright = (red + green + blue) / 3;
            if (max == null || max < bright) {
                max = bright;
            }
            if (min == null || min > bright) {
                min = bright;
            }
            totalBrightness = totalBrightness + bright;
        }
        Double b = totalBrightness / cnt;
        item.put((Object)"brightness", (Object)b);
        if (this.last != null) {
            item.put((Object)"brightness'", (Object)(b - this.last));
        }
        this.last = b;
        item.put((Object)"max:brightness", max);
        item.put((Object)"min:brightness", min);
        return item;
    }
}

