/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.data.DataFactory;
import stream.image.DisplayImage;
import stream.image.ImageRGB;
import stream.io.AbstractStream;
import stream.io.SourceURL;
import stream.runtime.ProcessContextImpl;

public class BMPImageStream
extends AbstractStream {
    static Logger log = LoggerFactory.getLogger(BMPImageStream.class);
    SourceURL url;

    public BMPImageStream(SourceURL source) {
        super(source);
    }

    public void init() throws Exception {
        super.init();
    }

    public Data readNext() throws Exception {
        try {
            String bfType = "";
            ByteBuffer head = ByteBuffer.allocate(54);
            ReadableByteChannel bc = Channels.newChannel(this.getInputStream());
            while (head.hasRemaining()) {
                int ret = bc.read(head);
                if (ret >= 0) continue;
                return null;
            }
            head.flip();
            head.order(ByteOrder.LITTLE_ENDIAN);
            bfType = new String(new char[]{(char)head.get(), (char)head.get()});
            int bfSize = head.getInt();
            int bfReserved = head.getInt();
            int bfOffsetBits = head.getInt();
            int biSize = head.getInt();
            int biWidth = head.getInt();
            int biHeight = head.getInt();
            short biPlanes = head.getShort();
            short biBitCount = head.getShort();
            int biCompression = head.getInt();
            int biSizeImage = head.getInt();
            int biXPelsPerMeter = head.getInt();
            int biYPelsPerMeter = head.getInt();
            int biClrUsed = head.getInt();
            int biClrImportant = head.getInt();
            if (log.isDebugEnabled()) {
                log.debug("bfType: {}", (Object)bfType);
                log.debug("bfSize: {}", (Object)bfSize);
                log.debug("bfReserved: {}", (Object)bfReserved);
                log.debug("bfOffsetBits: {}", (Object)bfOffsetBits);
                log.debug("biSize: {}", (Object)biSize);
                log.debug("biWidth: {}", (Object)biWidth);
                log.debug("biHeight: {}", (Object)biHeight);
                log.debug("biPlanes: {}", (Object)biPlanes);
                log.debug("biBitCount: {}", (Object)biBitCount);
                log.debug("biCompression: {}", (Object)biCompression);
                log.debug("biSizeImage: {}", (Object)biSizeImage);
                log.debug("biXPelsPerMeter: {}", (Object)biXPelsPerMeter);
                log.debug("biYPelsPerMeter: {}", (Object)biYPelsPerMeter);
                log.debug("biClrUsed: {}", (Object)biClrUsed);
                log.debug("biClrImportant: {}", (Object)biClrImportant);
            }
            log.info("Skipping {} bytes for BitmapInfoHeader...", (Object)biSize);
            ByteBuffer buf = ByteBuffer.allocate(biSizeImage);
            int read = bc.read(buf);
            while (buf.remaining() > 0) {
                read = bc.read(buf);
                if (read >= 0) continue;
                return null;
            }
            buf.flip();
            ImageRGB image = new ImageRGB(biWidth, biHeight);
            int len = image.pixels.length;
            for (int p = 1; p < len; ++p) {
                byte b = buf.get();
                int g = buf.get() << 8;
                int r = buf.get() << 16;
                image.pixels[len - p] = 0xFF000000 | r | g | b;
            }
            Data item = DataFactory.create();
            item.put((Object)"frame:image", (Object)image);
            item.put((Object)"frame:image:width", (Object)image.width);
            item.put((Object)"frame:image:height", (Object)image.height);
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        int count;
        BMPImageStream stream = new BMPImageStream(new SourceURL("file:/Volumes/RamDisk/rtl.bmp"));
        stream.init();
        DisplayImage display = new DisplayImage();
        display.setKey("frame:image");
        display.init((ProcessContext)new ProcessContextImpl());
        Long start = System.currentTimeMillis();
        Data item = stream.read();
        for (count = 0; item != null && count < 1; ++count) {
            display.process(item);
            item = stream.read();
        }
        Long duration = System.currentTimeMillis() - start;
        log.info("Rate is {}/sec", (Object)((double)count / (duration.doubleValue() / 1000.0)));
    }
}

