/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import stream.Data;
import stream.data.DataFactory;
import stream.image.ImageRGB;
import stream.io.AbstractStream;
import stream.io.JpegStream;
import stream.io.SourceURL;
import stream.util.ByteSize;

public class TiffImageStream
extends AbstractStream {
    public static final int DEFAULT_READ_BUFFER = 1024;
    public static final int DEFAULT_FRAME_BUFFER = 0x1000000;
    protected JpegStream stream;
    protected ByteSize readBufferSize = new ByteSize("1k");
    protected ByteSize bufferSize = new ByteSize("16mb");
    protected boolean continuous = false;
    int ok = 0;
    int errors = 0;
    long frame = 0L;

    public TiffImageStream(SourceURL url) throws Exception {
        super(url);
    }

    public TiffImageStream(InputStream in) throws Exception {
        super(in);
    }

    public ByteSize getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(ByteSize readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public ByteSize getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(ByteSize bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean continuous) {
        this.continuous = continuous;
    }

    public void init() throws Exception {
        super.init();
        log.debug("Initializing stream...");
        this.stream = new JpegStream(this.getInputStream(), this.readBufferSize.getBytes(), this.bufferSize.getBytes(), this.isContinuous());
        log.debug("Stream initialized.");
    }

    public Data readNext() throws Exception {
        byte[] data = this.stream.readNextChunk();
        if (data == null) {
            return null;
        }
        Data item = DataFactory.create();
        item.put((Object)"frame:size_raw", (Object)data.length);
        try {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(data));
            ImageRGB rgb = new ImageRGB(img);
            item.put((Object)"frame:image", (Object)rgb);
            item.put((Object)"frame:width", (Object)rgb.width);
            item.put((Object)"frame:height", (Object)rgb.height);
            ++this.ok;
            log.debug("Successfully parsed JPEG image...");
        }
        catch (Exception e) {
            log.error("Failed to read from image: {}", (Object)e.getMessage());
            ++this.errors;
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            item.put((Object)"error:data", (Object)data);
        }
        return item;
    }

    public void close() throws Exception {
        super.close();
    }

    public void info() {
        log.info("{} frames were read without problems.", (Object)this.ok);
        log.info("{} frames could not be read", (Object)this.errors);
        log.info("{} frames read in total.", (Object)(this.ok + this.errors));
    }

    public static void main(String[] args) throws Exception {
        SourceURL url = new SourceURL("file:/Volumes/RamDisk/laser.mjpeg");
        TiffImageStream stream = new TiffImageStream(url);
        stream.setReadBufferSize(new ByteSize("1k"));
        stream.setBufferSize(new ByteSize("8mb"));
        stream.init();
        int frames = 0;
        Data item = null;
        do {
            if ((item = stream.read()) == null) continue;
            ++frames;
        } while (item != null);
        log.info("{} frames read.", (Object)frames);
    }
}

