/*
 * Decompiled with CFR 0.152.
 */
package stream.audio;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.audio.PlayWavData;
import stream.data.DataFactory;
import stream.io.AbstractStream;
import stream.runtime.ProcessContextImpl;

public class SinusWave
extends AbstractStream {
    static Logger log = LoggerFactory.getLogger(SinusWave.class);
    Float amplitude = Float.valueOf(127.0f);
    Double frequency = 261.63;
    Integer sampleRate = 48000;
    int blockSize = this.sampleRate;
    double[] block;
    int blocksRead = 0;
    int off = 0;
    String prefix = "wav:";
    String key = "samples";

    public Float getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(Float amplitude) {
        this.amplitude = amplitude;
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Integer sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void init() throws Exception {
        super.init();
        this.block = new double[this.sampleRate.intValue()];
        Double interval = this.sampleRate.doubleValue() / this.frequency;
        log.info("Sinus interval is {}", (Object)interval);
    }

    public Data readNext() throws Exception {
        Data item = DataFactory.create();
        if (this.blocksRead == 0) {
            item.put((Object)(this.prefix + "samplerate"), (Object)this.sampleRate);
            item.put((Object)(this.prefix + "channels"), (Object)1);
            item.put((Object)(this.prefix + "bytesPerSample"), (Object)1);
        }
        double freq = this.frequency;
        double sampleInterval = this.sampleRate.doubleValue() / freq;
        double[] bytes = new double[this.blockSize];
        for (int i = 0; i < this.block.length; ++i) {
            double angle = Math.PI * 2 * (double)(this.off + i) / sampleInterval;
            bytes[i % this.block.length] = Math.sin(angle) * (double)this.amplitude.floatValue();
        }
        this.off += bytes.length;
        item.put((Object)(this.prefix + this.key), (Object)bytes);
        ++this.blocksRead;
        return item;
    }

    public static void main(String[] args) {
        try {
            SinusWave sine = new SinusWave();
            sine.init();
            int count = 0;
            PlayWavData sound = new PlayWavData();
            sound.init((ProcessContext)new ProcessContextImpl());
            Data item = sine.read();
            while (item != null && count++ < 100) {
                log.info("Sample: {}", (Object)item);
                sound.process(item);
                item = sine.read();
            }
            sine.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

