/*
 * Decompiled with CFR 0.152.
 */
package stream.audio;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;

public class Volume
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(Volume.class);
    String key = "wav:samples";
    int windowSize = 25;
    double[] window = new double[this.windowSize];
    int idx = 0;
    double current = 0.0;

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.window = new double[this.windowSize];
        for (int i = 0; i < this.window.length; ++i) {
            this.window[i] = 0.0;
        }
    }

    public Data process(Data input) {
        try {
            double[] samples = (double[])input.get((Object)this.key);
            if (samples == null) {
                return input;
            }
            double avg = 0.0;
            for (int i = 0; i < samples.length; ++i) {
                avg = Math.max(avg, samples[i]);
            }
            this.current += avg;
            this.current -= this.window[(this.idx + 1) % this.window.length];
            this.window[(this.idx + 1) % this.window.length] = avg;
            input.put((Object)"wav:volume", (Object)(this.current / (double)this.window.length));
            ++this.idx;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return input;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(Integer windowSize) {
        this.windowSize = windowSize;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

