/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.image.ImageRGB;

public class BlackFrameDetector
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(BlackFrameDetector.class);
    String key = "frame:image";
    Double threshold = 0.9;

    public Data process(Data input) {
        try {
            ImageRGB image = (ImageRGB)input.get((Object)this.key);
            if (image != null) {
                int[] pixels = image.pixels;
                Integer total = pixels.length;
                Integer black = 0;
                for (int i = 0; i < total; ++i) {
                    int b;
                    int g;
                    int argb = pixels[i];
                    int r = (0xFF0000 & argb) >> 16;
                    if (!(r < 8 & (g = (0xFF00 & argb) >> 8) < 8 & (b = 0xFF & argb) < 8)) continue;
                    Integer n = black;
                    Integer n2 = black = Integer.valueOf(black + 1);
                }
                Double fraction = black.doubleValue() / total.doubleValue();
                input.put((Object)"blackRate", (Object)(100.0 * fraction));
                if (fraction > this.threshold) {
                    input.put((Object)"frame:mark:blackFrame", (Object)1.0);
                } else {
                    input.put((Object)"frame:mark:blackFrame", (Object)0.0);
                }
            }
        }
        catch (Exception e) {
            log.error("Error: {}", (Object)e.getMessage());
        }
        return input;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }
}

