/*
 * Decompiled with CFR 0.152.
 */
package stream.image;

import stream.Data;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class ChangedPixelRatio
extends AbstractImageProcessor {
    String output = "frame:diff:changeratio";

    public String getOutput() {
        return this.output;
    }

    @Parameter(description="This parameter sets the key under which the changed pixel ratio is stored in the output data item.")
    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        int counter = 0;
        for (int i = 0; i < img.getWidth(); ++i) {
            for (int j = 0; j < img.getHeight(); ++j) {
                int blue;
                int green;
                int red = img.getRED(i, j);
                if (red + (green = img.getGREEN(i, j)) + (blue = img.getBLUE(i, j)) <= 25) continue;
                ++counter;
            }
        }
        Double ratio = (double)counter / (double)(img.getHeight() * img.getWidth());
        item.put((Object)this.output, (Object)ratio);
        return item;
    }
}

