/*
 * Decompiled with CFR 0.152.
 */
package stream.image.features;

import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class MedianRGB
extends AbstractImageProcessor {
    @Override
    public Data process(Data item, ImageRGB img) {
        int[] rvalues = new int[256];
        int[] gvalues = new int[256];
        int[] bvalues = new int[256];
        for (int i = 0; i < img.pixels.length; ++i) {
            int argb = img.pixels[i];
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            int n = red;
            rvalues[n] = rvalues[n] + 1;
            int n2 = green;
            gvalues[n2] = gvalues[n2] + 1;
            int n3 = blue;
            bvalues[n3] = bvalues[n3] + 1;
        }
        int median = img.getWidth() * img.getHeight() / 2;
        int r = 0;
        int g = 0;
        int b = 0;
        int i = 0;
        while (i < median) {
            i += rvalues[r];
            ++r;
        }
        i = 0;
        while (i < median) {
            i += gvalues[g];
            ++g;
        }
        i = 0;
        while (i < median) {
            i += bvalues[b];
            ++b;
        }
        item.put((Object)"frame:red:median", (Object)r);
        item.put((Object)"frame:green:median", (Object)g);
        item.put((Object)"frame:blue:median", (Object)b);
        return item;
    }
}

