/*
 * Decompiled with CFR 0.152.
 */
package stream.image.features;

import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class StandardDeviationRGB
extends AbstractImageProcessor {
    String averageRedKey = "frame:red:average";
    String averageGreenKey = "frame:green:average";
    String averageBlueKey = "frame:blue:average";

    @Override
    public Data process(Data item, ImageRGB img) {
        Double averageRed = (Double)item.get((Object)this.averageRedKey);
        Double averageGreen = (Double)item.get((Object)this.averageGreenKey);
        Double averageBlue = (Double)item.get((Object)this.averageBlueKey);
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double px = img.pixels.length;
        for (int i = 0; i < img.pixels.length; ++i) {
            int argb = img.pixels[i];
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            r += Math.abs((double)red - averageRed);
            g += Math.abs((double)green - averageGreen);
            b += Math.abs((double)blue - averageBlue);
        }
        item.put((Object)"frame:red:standardDeviation", (Object)(r / px));
        item.put((Object)"frame:blue:standardDeviation", (Object)(b / px));
        item.put((Object)"frame:green:standardDeviation", (Object)(g / px));
        return item;
    }
}

