/*
 * Decompiled with CFR 0.152.
 */
package stream.image.filters;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class Smoothing
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(Smoothing.class);
    String output = "smooth";
    Integer windowSize = 3;
    Boolean weighted = false;
    int[][] weightingMatrix = null;
    int weightsum = 0;

    public Integer getWindowSize() {
        return this.windowSize;
    }

    @Parameter(description="Sets the window size. The window size determines the neighboring pixels for each pixel, that are averaged. A windowSize of 3 means that 3 times 3 = 9 pixels are taken into account.")
    public void setWindowSize(Integer windowSize) {
        this.windowSize = windowSize;
    }

    @Parameter(description="If a weighted smoothing technique is selected, neighbors closer to the pixel to be smoothend are counted with a higher weight.")
    public void setWeighted(Boolean weighted) {
        this.weighted = weighted;
    }

    public String getOutput() {
        return this.output;
    }

    @Parameter(description="The name/key of the output image is stored. If this name equals the name of the input image, the input image is going to be overwritten.")
    public void setOutput(String output) {
        this.output = output;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.weightingMatrix = new int[this.windowSize.intValue()][this.windowSize.intValue()];
        this.weightsum = 0;
        if (!this.weighted.booleanValue()) {
            for (int i = 0; i < this.weightingMatrix.length; ++i) {
                for (int j = 0; j < this.weightingMatrix[i].length; ++j) {
                    this.weightingMatrix[i][j] = 1;
                    ++this.weightsum;
                }
            }
        }
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        int border;
        ImageRGB smoothedImage = new ImageRGB(img.getWidth(), img.getHeight());
        for (int x = border = this.windowSize / 2; x < smoothedImage.getWidth() - border; ++x) {
            for (int y = border; y < smoothedImage.getHeight() - border; ++y) {
                int red = 0;
                for (int i = 0; i < this.windowSize; ++i) {
                    for (int j = 0; j < this.windowSize; ++j) {
                        red += this.weightingMatrix[i][j] * img.getRED(x - border + i, y - border + j);
                    }
                }
                red /= this.weightsum;
                int green = 0;
                for (int i = 0; i < this.windowSize; ++i) {
                    for (int j = 0; j < this.windowSize; ++j) {
                        green += this.weightingMatrix[i][j] * img.getGREEN(x - border + i, y - border + j);
                    }
                }
                green /= this.weightsum;
                int blue = 0;
                for (int i = 0; i < this.windowSize; ++i) {
                    for (int j = 0; j < this.windowSize; ++j) {
                        blue += this.weightingMatrix[i][j] * img.getBLUE(x - border + i, y - border + j);
                    }
                }
                smoothedImage.setRGB(x, y, red, green, blue /= this.weightsum);
            }
        }
        log.info("emitting smoothed image as attribute '{}'", (Object)this.output);
        item.put((Object)this.output, (Object)smoothedImage);
        return item;
    }
}

