/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.impl;

import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidWithLocalpart;
import org.jxmpp.jid.JidWithResource;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;

public abstract class AbstractJid
implements Jid {
    private static final long serialVersionUID = 1L;

    @Override
    public final boolean isBareOrFullJid() {
        return this.isBareJid() || this.isFullJid();
    }

    @Override
    public final boolean isBareJid() {
        return this instanceof BareJid;
    }

    @Override
    public final boolean isFullJid() {
        return this instanceof FullJid;
    }

    @Override
    public final boolean isDomainBareJid() {
        return this instanceof DomainBareJid;
    }

    @Override
    public final boolean isDomainFullJid() {
        return this instanceof DomainFullJid;
    }

    @Override
    public abstract boolean hasNoResource();

    @Override
    public final boolean hasResource() {
        return this instanceof JidWithResource;
    }

    @Override
    public final boolean hasLocalpart() {
        return this instanceof JidWithLocalpart;
    }

    @Override
    public final <T extends Jid> T downcast() {
        return (T)this;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public abstract Resourcepart getResourceOrNull();

    @Override
    public abstract Localpart getLocalpartOrNull();

    @Override
    public final boolean isParentOf(Jid jid) {
        FullJid fullJid = jid.asFullJidIfPossible();
        if (fullJid != null) {
            return this.isParentOf(fullJid);
        }
        BareJid bareJid = jid.asBareJidIfPossible();
        if (bareJid != null) {
            return this.isParentOf(bareJid);
        }
        DomainFullJid domainFullJid = jid.asDomainFullJidIfPossible();
        if (domainFullJid != null) {
            return this.isParentOf(domainFullJid);
        }
        return this.isParentOf(jid.asDomainBareJid());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof CharSequence) {
            return this.equals((CharSequence)other);
        }
        return false;
    }

    @Override
    public final boolean equals(CharSequence charSequence) {
        return this.equals(charSequence.toString());
    }

    @Override
    public final boolean equals(String string) {
        return this.toString().equals(string);
    }

    @Override
    public final int compareTo(Jid other) {
        String otherString = other.toString();
        String myString = this.toString();
        return myString.compareTo(otherString);
    }
}

