/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.impl;

import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;

public abstract class AbstractJid
implements Jid {
    private static final long serialVersionUID = 1L;
    private transient String internalizedCache;

    @Override
    public final boolean isEntityJid() {
        return this.isEntityBareJid() || this.isEntityFullJid();
    }

    @Override
    public final boolean isEntityBareJid() {
        return this instanceof EntityBareJid;
    }

    @Override
    public final boolean isEntityFullJid() {
        return this instanceof EntityFullJid;
    }

    @Override
    public final boolean isDomainBareJid() {
        return this instanceof DomainBareJid;
    }

    @Override
    public final boolean isDomainFullJid() {
        return this instanceof DomainFullJid;
    }

    @Override
    public abstract boolean hasNoResource();

    @Override
    public final boolean hasResource() {
        return this instanceof FullJid;
    }

    @Override
    public final boolean hasLocalpart() {
        return this instanceof EntityJid;
    }

    @Override
    public final <T extends Jid> T downcast() {
        return (T)this;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public abstract Resourcepart getResourceOrNull();

    @Override
    public abstract Localpart getLocalpartOrNull();

    @Override
    public final boolean isParentOf(Jid jid) {
        EntityFullJid fullJid = jid.asEntityFullJidIfPossible();
        if (fullJid != null) {
            return this.isParentOf(fullJid);
        }
        EntityBareJid bareJid = jid.asEntityBareJidIfPossible();
        if (bareJid != null) {
            return this.isParentOf(bareJid);
        }
        DomainFullJid domainFullJid = jid.asDomainFullJidIfPossible();
        if (domainFullJid != null) {
            return this.isParentOf(domainFullJid);
        }
        return this.isParentOf(jid.asDomainBareJid());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof CharSequence) {
            return this.equals((CharSequence)other);
        }
        return false;
    }

    @Override
    public final boolean equals(CharSequence charSequence) {
        return this.equals(charSequence.toString());
    }

    @Override
    public final boolean equals(String string) {
        return this.toString().equals(string);
    }

    @Override
    public final int compareTo(Jid other) {
        String otherString = other.toString();
        String myString = this.toString();
        return myString.compareTo(otherString);
    }

    @Override
    public final String intern() {
        if (this.internalizedCache == null) {
            this.internalizedCache = this.toString().intern();
        }
        return this.internalizedCache;
    }
}

