/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.impl;

import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.DomainAndResourcepartJid;
import org.jxmpp.jid.impl.DomainpartJid;
import org.jxmpp.jid.impl.LocalAndDomainpartJid;
import org.jxmpp.jid.impl.LocalDomainAndResourcepartJid;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.LruCache;

public class JidCreate {
    private static final Cache<String, Jid> JID_CACHE = new LruCache(100);
    private static final Cache<String, EntityBareJid> BAREJID_CACHE = new LruCache(100);
    private static final Cache<String, EntityFullJid> FULLJID_CACHE = new LruCache(100);
    private static final Cache<String, DomainBareJid> DOMAINJID_CACHE = new LruCache(100);
    private static final Cache<String, DomainFullJid> DOMAINRESOURCEJID_CACHE = new LruCache(100);

    public static Jid from(CharSequence localpart, CharSequence domainpart, CharSequence resource) throws XmppStringprepException {
        return JidCreate.from(localpart.toString(), domainpart.toString(), resource.toString());
    }

    public static Jid from(String localpart, String domainpart, String resource) throws XmppStringprepException {
        String jidString = XmppStringUtils.completeJidFrom((String)localpart, (String)domainpart, (String)resource);
        Jid jid = (Jid)JID_CACHE.get((Object)jidString);
        if (jid != null) {
            return jid;
        }
        if (localpart.length() > 0 && domainpart.length() > 0 && resource.length() > 0) {
            jid = new LocalDomainAndResourcepartJid(localpart, domainpart, resource);
        } else if (localpart.length() > 0 && domainpart.length() > 0 && resource.length() == 0) {
            jid = new LocalAndDomainpartJid(localpart, domainpart);
        } else if (localpart.length() == 0 && domainpart.length() > 0 && resource.length() == 0) {
            jid = new DomainpartJid(domainpart);
        } else if (localpart.length() == 0 && domainpart.length() > 0 && resource.length() > 0) {
            jid = new DomainAndResourcepartJid(domainpart, resource);
        } else {
            throw new IllegalArgumentException("Not a valid combination of localpart, domainpart and resource");
        }
        JID_CACHE.put((Object)jidString, (Object)jid);
        return jid;
    }

    public static Jid from(CharSequence jid) throws XmppStringprepException {
        return JidCreate.from(jid.toString());
    }

    public static Jid from(String jidString) throws XmppStringprepException {
        String localpart = XmppStringUtils.parseLocalpart((String)jidString);
        String domainpart = XmppStringUtils.parseDomain((String)jidString);
        String resource = XmppStringUtils.parseResource((String)jidString);
        try {
            return JidCreate.from(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jidString, (Exception)((Object)e));
        }
    }

    public static Jid fromUnescaped(CharSequence unescapedJid) throws XmppStringprepException {
        return JidCreate.fromUnescaped(unescapedJid.toString());
    }

    public static Jid fromUnescaped(String unescapedJidString) throws XmppStringprepException {
        String localpart = XmppStringUtils.parseLocalpart((String)unescapedJidString);
        localpart = XmppStringUtils.escapeLocalpart((String)localpart);
        String domainpart = XmppStringUtils.parseDomain((String)unescapedJidString);
        String resource = XmppStringUtils.parseResource((String)unescapedJidString);
        try {
            return JidCreate.from(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(unescapedJidString, (Exception)((Object)e));
        }
    }

    public static EntityBareJid bareFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.bareFrom(jid.toString());
    }

    public static EntityBareJid bareFrom(String jid) throws XmppStringprepException {
        EntityBareJid bareJid = (EntityBareJid)BAREJID_CACHE.get((Object)jid);
        if (bareJid != null) {
            return bareJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        try {
            bareJid = new LocalAndDomainpartJid(localpart, domainpart);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        BAREJID_CACHE.put((Object)jid, (Object)bareJid);
        return bareJid;
    }

    public static EntityBareJid bareFrom(Localpart localpart, DomainBareJid domainBareJid) {
        return JidCreate.bareFrom(localpart, domainBareJid.getDomain());
    }

    public static EntityBareJid bareFrom(Localpart localpart, Domainpart domain) {
        return new LocalAndDomainpartJid(localpart, domain);
    }

    public static EntityFullJid fullFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.fullFrom(jid.toString());
    }

    public static EntityFullJid fullFrom(String jid) throws XmppStringprepException {
        EntityFullJid fullJid = (EntityFullJid)FULLJID_CACHE.get((Object)jid);
        if (fullJid != null) {
            return fullJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        String resource = XmppStringUtils.parseResource((String)jid);
        try {
            fullJid = JidCreate.fullFrom(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        FULLJID_CACHE.put((Object)jid, (Object)fullJid);
        return fullJid;
    }

    public static EntityFullJid fullFrom(String localpart, String domainpart, String resource) throws XmppStringprepException {
        LocalDomainAndResourcepartJid fullJid;
        try {
            fullJid = new LocalDomainAndResourcepartJid(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(localpart + '@' + domainpart + '/' + resource, (Exception)((Object)e));
        }
        return fullJid;
    }

    public static EntityFullJid fullFrom(Localpart localpart, DomainBareJid domainBareJid, Resourcepart resource) {
        return JidCreate.fullFrom(localpart, domainBareJid.getDomain(), resource);
    }

    public static EntityFullJid fullFrom(Localpart localpart, Domainpart domainpart, Resourcepart resource) {
        return JidCreate.fullFrom(JidCreate.bareFrom(localpart, domainpart), resource);
    }

    public static EntityFullJid fullFrom(EntityBareJid bareJid, Resourcepart resource) {
        return new LocalDomainAndResourcepartJid(bareJid, resource);
    }

    @Deprecated
    public static DomainBareJid serverBareFrom(String jid) throws XmppStringprepException {
        return JidCreate.domainBareFrom(jid);
    }

    public static DomainBareJid domainBareFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.domainBareFrom(jid.toString());
    }

    public static DomainBareJid domainBareFrom(String jid) throws XmppStringprepException {
        DomainBareJid domainJid = (DomainBareJid)DOMAINJID_CACHE.get((Object)jid);
        if (domainJid != null) {
            return domainJid;
        }
        String domain = XmppStringUtils.parseDomain((String)jid);
        try {
            domainJid = new DomainpartJid(domain);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        DOMAINJID_CACHE.put((Object)jid, (Object)domainJid);
        return domainJid;
    }

    public static DomainBareJid domainBareFrom(Domainpart domainpart) {
        return new DomainpartJid(domainpart);
    }

    @Deprecated
    public static DomainFullJid serverFullFrom(String jid) throws XmppStringprepException {
        return JidCreate.donmainFullFrom(jid);
    }

    @Deprecated
    public static DomainFullJid donmainFullFrom(String jid) throws XmppStringprepException {
        return JidCreate.domainFullFrom(jid);
    }

    public static DomainFullJid domainFullFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.domainFullFrom(jid.toString());
    }

    public static DomainFullJid domainFullFrom(String jid) throws XmppStringprepException {
        DomainFullJid domainResourceJid = (DomainFullJid)DOMAINRESOURCEJID_CACHE.get((Object)jid);
        if (domainResourceJid != null) {
            return domainResourceJid;
        }
        String domain = XmppStringUtils.parseDomain((String)jid);
        String resource = XmppStringUtils.parseResource((String)jid);
        try {
            domainResourceJid = new DomainAndResourcepartJid(domain, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        DOMAINRESOURCEJID_CACHE.put((Object)jid, (Object)domainResourceJid);
        return domainResourceJid;
    }

    public static DomainFullJid domainFullFrom(Domainpart domainpart, Resourcepart resource) {
        return JidCreate.domainFullFrom(JidCreate.domainBareFrom(domainpart), resource);
    }

    public static DomainFullJid domainFullFrom(DomainBareJid domainBareJid, Resourcepart resource) {
        return new DomainAndResourcepartJid(domainBareJid, resource);
    }
}

