/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;

public class JidUtil {
    public static boolean isTypicalValidEntityBareJid(CharSequence jid) {
        try {
            JidUtil.validateTypicalEntityBareJid(jid);
        }
        catch (NotAEntityBareJidStringException | XmppStringprepException e) {
            return false;
        }
        return true;
    }

    public static EntityBareJid validateTypicalEntityBareJid(CharSequence jidcs) throws NotAEntityBareJidStringException, XmppStringprepException {
        EntityBareJid jid = JidUtil.validateEntityBareJid(jidcs);
        if (jid.getDomain().toString().indexOf(46) == -1) {
            throw new NotAEntityBareJidStringException("Domainpart does not include a dot ('.') character");
        }
        return jid;
    }

    public static boolean isValidEntityBareJid(CharSequence jid) {
        try {
            JidUtil.validateEntityBareJid(jid);
        }
        catch (NotAEntityBareJidStringException | XmppStringprepException e) {
            return false;
        }
        return true;
    }

    public static EntityBareJid validateEntityBareJid(CharSequence jidcs) throws NotAEntityBareJidStringException, XmppStringprepException {
        String jid = jidcs.toString();
        int atIndex = jid.indexOf(64);
        if (atIndex == -1) {
            throw new NotAEntityBareJidStringException("'" + jid + "' does not contain a '@' character");
        }
        if (jid.indexOf(64, atIndex + 1) != -1) {
            throw new NotAEntityBareJidStringException("'" + jid + "' contains multiple '@' characters");
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        if (localpart.length() == 0) {
            throw new NotAEntityBareJidStringException("'" + jid + "' has empty localpart");
        }
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        if (domainpart.length() == 0) {
            throw new NotAEntityBareJidStringException("'" + jid + "' has empty domainpart");
        }
        return JidCreate.entityBareFromUnescaped(jid);
    }

    public static void filterEntityBareJid(Collection<? extends Jid> in, Collection<? super EntityBareJid> out) {
        for (Jid jid : in) {
            EntityBareJid bareJid = jid.asEntityBareJidIfPossible();
            if (bareJid == null) continue;
            out.add(bareJid);
        }
    }

    public static Set<EntityBareJid> filterEntityBareJidSet(Collection<? extends Jid> input) {
        HashSet<EntityBareJid> res = new HashSet<EntityBareJid>(input.size());
        JidUtil.filterEntityBareJid(input, res);
        return res;
    }

    public static List<EntityBareJid> filterEntityBareJidList(Collection<? extends Jid> input) {
        ArrayList<EntityBareJid> res = new ArrayList<EntityBareJid>(input.size());
        JidUtil.filterEntityBareJid(input, res);
        return res;
    }

    public static void filterEntityFullJid(Collection<? extends Jid> in, Collection<? super EntityFullJid> out) {
        for (Jid jid : in) {
            EntityFullJid fullJid = jid.asEntityFullJidIfPossible();
            if (fullJid == null) continue;
            out.add(fullJid);
        }
    }

    public static Set<EntityFullJid> filterEntityFullJidSet(Collection<? extends Jid> input) {
        HashSet<EntityFullJid> res = new HashSet<EntityFullJid>(input.size());
        JidUtil.filterEntityFullJid(input, res);
        return res;
    }

    public static List<EntityFullJid> filterEntityFullJidList(Collection<? extends Jid> input) {
        ArrayList<EntityFullJid> res = new ArrayList<EntityFullJid>(input.size());
        JidUtil.filterEntityFullJid(input, res);
        return res;
    }

    public static void filterDomainFullJid(Collection<? extends Jid> in, Collection<? super DomainFullJid> out) {
        for (Jid jid : in) {
            DomainFullJid domainFullJid = jid.asDomainFullJidIfPossible();
            if (domainFullJid == null) continue;
            out.add(domainFullJid);
        }
    }

    public static Set<DomainFullJid> filterDomainFullJidSet(Collection<? extends Jid> input) {
        HashSet<DomainFullJid> res = new HashSet<DomainFullJid>(input.size());
        JidUtil.filterDomainFullJid(input, res);
        return res;
    }

    public static List<DomainFullJid> filterDomainFullJidList(Collection<? extends Jid> input) {
        ArrayList<DomainFullJid> res = new ArrayList<DomainFullJid>(input.size());
        JidUtil.filterDomainFullJid(input, res);
        return res;
    }

    public static Set<EntityBareJid> entityBareJidSetFrom(Collection<? extends CharSequence> jidStrings) {
        HashSet<EntityBareJid> res = new HashSet<EntityBareJid>(jidStrings.size());
        JidUtil.entityBareJidsFrom(jidStrings, res, null);
        return res;
    }

    public static void entityBareJidsFrom(Collection<? extends CharSequence> jidStrings, Collection<? super EntityBareJid> output, List<XmppStringprepException> exceptions) {
        for (CharSequence charSequence : jidStrings) {
            try {
                EntityBareJid bareJid = JidCreate.entityBareFrom(charSequence);
                output.add(bareJid);
            }
            catch (XmppStringprepException e) {
                if (exceptions != null) {
                    exceptions.add(e);
                    continue;
                }
                throw new AssertionError((Object)e);
            }
        }
    }

    public static Set<Jid> jidSetFrom(String[] jids) {
        return JidUtil.jidSetFrom(Arrays.asList(jids));
    }

    public static Set<Jid> jidSetFrom(Collection<? extends CharSequence> jidStrings) {
        HashSet<Jid> res = new HashSet<Jid>(jidStrings.size());
        JidUtil.jidsFrom(jidStrings, res, null);
        return res;
    }

    public static void jidsFrom(Collection<? extends CharSequence> jidStrings, Collection<? super Jid> output, List<XmppStringprepException> exceptions) {
        for (CharSequence charSequence : jidStrings) {
            try {
                Jid jid = JidCreate.from(charSequence);
                output.add(jid);
            }
            catch (XmppStringprepException e) {
                if (exceptions != null) {
                    exceptions.add(e);
                    continue;
                }
                throw new AssertionError((Object)e);
            }
        }
    }

    public static List<String> toStringList(Collection<? extends Jid> jids) {
        ArrayList<String> res = new ArrayList<String>(jids.size());
        JidUtil.toStrings(jids, res);
        return res;
    }

    public static Set<String> toStringSet(Collection<? extends Jid> jids) {
        HashSet<String> res = new HashSet<String>(jids.size());
        JidUtil.toStrings(jids, res);
        return res;
    }

    public static void toStrings(Collection<? extends Jid> jids, Collection<? super String> jidStrings) {
        for (Jid jid : jids) {
            jidStrings.add(jid.toString());
        }
    }

    public static class NotAEntityBareJidStringException
    extends Exception {
        private static final long serialVersionUID = -1710386661031655082L;

        public NotAEntityBareJidStringException(String message) {
            super(message);
        }
    }
}

