/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.impl;

import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class JidCreateTest {
    @Test
    public void bareFromThrowTest() {
        String notABareJid = "example.org/test";
        try {
            EntityBareJid jid = JidCreate.entityBareFrom((String)"example.org/test");
            Assert.fail((String)(jid + " should never been created"));
        }
        catch (XmppStringprepException e) {
            Assert.assertEquals((Object)"example.org/test", (Object)e.getCausingString());
        }
    }

    @Test
    public void fullFromThrowTest() {
        String notAFullJid = "user@example.org/";
        try {
            EntityFullJid jid = JidCreate.entityFullFrom((String)"user@example.org/");
            Assert.fail((String)(jid + " should never been created"));
        }
        catch (XmppStringprepException e) {
            Assert.assertEquals((Object)"user@example.org/", (Object)e.getCausingString());
        }
    }

    @Test
    public void domainBareThrowTest() {
        String notADomainBareJid = "";
        try {
            DomainBareJid jid = JidCreate.domainBareFrom((String)"");
            Assert.fail((String)(jid + " should never been created"));
        }
        catch (XmppStringprepException e) {
            Assert.assertEquals((Object)"", (Object)e.getCausingString());
        }
    }

    @Test
    public void domainFullThrowTest() {
        String notADomainFullJid = "example.org";
        try {
            DomainFullJid jid = JidCreate.domainFullFrom((String)"example.org");
            Assert.fail((String)(jid + " should never been created"));
        }
        catch (XmppStringprepException e) {
            Assert.assertEquals((Object)"example.org", (Object)e.getCausingString());
        }
    }

    @Test
    public void entityBareFromUnescapedTest() throws XmppStringprepException {
        EntityBareJid entityBareJid = JidCreate.entityBareFromUnescaped((String)"foo@boo@example.org/baz");
        Domainpart domainpart = entityBareJid.getDomain();
        Assert.assertEquals((Object)Domainpart.from((String)"boo@example.org"), (Object)domainpart);
        Localpart localpart = entityBareJid.getLocalpart();
        Assert.assertEquals((Object)Localpart.from((String)"foo"), (Object)localpart);
    }

    @Test
    public void entityFullFromComplexTest() throws XmppStringprepException {
        EntityFullJid entityFullJid = JidCreate.entityFullFrom((String)"foo@boo@example.org/bar@baz");
        Domainpart domainpart = entityFullJid.getDomain();
        Assert.assertEquals((Object)Domainpart.from((String)"boo@example.org"), (Object)domainpart);
        Localpart localpart = entityFullJid.getLocalpart();
        Assert.assertEquals((Object)Localpart.from((String)"foo"), (Object)localpart);
        Resourcepart resourcepart = entityFullJid.getResourcepart();
        Assert.assertEquals((Object)Resourcepart.from((String)"bar@baz"), (Object)resourcepart);
    }

    @Test
    public void entityFullFromUnsecapedComplexTest() throws XmppStringprepException {
        EntityFullJid entityFullJid = JidCreate.entityFullFromUnescaped((String)"foo@boo@example.org/bar@baz");
        Domainpart domainpart = entityFullJid.getDomain();
        Assert.assertEquals((Object)Domainpart.from((String)"boo@example.org"), (Object)domainpart);
        Localpart localpart = entityFullJid.getLocalpart();
        Assert.assertEquals((Object)Localpart.from((String)"foo"), (Object)localpart);
        Resourcepart resourcepart = entityFullJid.getResourcepart();
        Assert.assertEquals((Object)Resourcepart.from((String)"bar@baz"), (Object)resourcepart);
    }

    @Test
    public void entityFromUnescapedBareTest() throws XmppStringprepException {
        EntityJid entityJid = JidCreate.entityFromUnescaped((String)"d'artagnan@musketeers.lit");
        Domainpart domainpart = entityJid.getDomain();
        Assert.assertEquals((Object)Domainpart.from((String)"musketeers.lit"), (Object)domainpart);
        Localpart localpart = entityJid.getLocalpart();
        Assert.assertEquals((Object)Localpart.from((String)"d\\27artagnan"), (Object)localpart);
        Assert.assertEquals((Object)localpart, (Object)Localpart.fromUnescaped((String)"d'artagnan"));
    }

    @Test
    public void entityFromUnescapedFullTest() throws XmppStringprepException {
        EntityJid entityBareJid = JidCreate.entityFromUnescaped((String)"d'artagnan@gascon.fr/elder");
        Domainpart domainpart = entityBareJid.getDomain();
        Assert.assertEquals((Object)Domainpart.from((String)"gascon.fr"), (Object)domainpart);
        Resourcepart resourcepart = entityBareJid.getResourceOrThrow();
        Assert.assertEquals((Object)Resourcepart.from((String)"elder"), (Object)resourcepart);
        Localpart localpart = entityBareJid.getLocalpart();
        Assert.assertEquals((Object)Localpart.from((String)"d\\27artagnan"), (Object)localpart);
    }
}

