/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.AbstractJid;
import org.jxmpp.jid.impl.DomainAndResourcepartJid;
import org.jxmpp.jid.impl.DomainpartJid;
import org.jxmpp.jid.impl.LocalAndDomainpartJid;
import org.jxmpp.jid.impl.LocalDomainAndResourcepartJid;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.LruCache;

public class JidCreate {
    private static final Cache<String, Jid> JID_CACHE = new LruCache(100);
    private static final Cache<String, BareJid> BAREJID_CACHE = new LruCache(100);
    private static final Cache<String, EntityJid> ENTITYJID_CACHE = new LruCache(100);
    private static final Cache<String, FullJid> FULLJID_CACHE = new LruCache(100);
    private static final Cache<String, EntityBareJid> ENTITY_BAREJID_CACHE = new LruCache(100);
    private static final Cache<String, EntityFullJid> ENTITY_FULLJID_CACHE = new LruCache(100);
    private static final Cache<String, DomainBareJid> DOMAINJID_CACHE = new LruCache(100);
    private static final Cache<String, DomainFullJid> DOMAINRESOURCEJID_CACHE = new LruCache(100);

    public static Jid from(CharSequence localpart, CharSequence domainpart, CharSequence resource) throws XmppStringprepException {
        return JidCreate.from(localpart.toString(), domainpart.toString(), resource.toString());
    }

    public static Jid from(String localpart, String domainpart, String resource) throws XmppStringprepException {
        String jidString = XmppStringUtils.completeJidFrom((String)localpart, (String)domainpart, (String)resource);
        Jid jid = (Jid)JID_CACHE.lookup((Object)jidString);
        if (jid != null) {
            return jid;
        }
        if (localpart.length() > 0 && domainpart.length() > 0 && resource.length() > 0) {
            jid = new LocalDomainAndResourcepartJid(localpart, domainpart, resource);
        } else if (localpart.length() > 0 && domainpart.length() > 0 && resource.length() == 0) {
            jid = new LocalAndDomainpartJid(localpart, domainpart);
        } else if (localpart.length() == 0 && domainpart.length() > 0 && resource.length() == 0) {
            jid = new DomainpartJid(domainpart);
        } else if (localpart.length() == 0 && domainpart.length() > 0 && resource.length() > 0) {
            jid = new DomainAndResourcepartJid(domainpart, resource);
        } else {
            throw new IllegalArgumentException("Not a valid combination of localpart, domainpart and resource");
        }
        JID_CACHE.put((Object)jidString, (Object)jid);
        return jid;
    }

    public static Jid fromOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.from(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Jid from(CharSequence jid) throws XmppStringprepException {
        return JidCreate.from(jid.toString());
    }

    public static Jid from(String jidString) throws XmppStringprepException {
        String localpart = XmppStringUtils.parseLocalpart((String)jidString);
        String domainpart = XmppStringUtils.parseDomain((String)jidString);
        String resource = XmppStringUtils.parseResource((String)jidString);
        try {
            return JidCreate.from(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jidString, (Exception)((Object)e));
        }
    }

    public static Jid fromOrNull(CharSequence cs) {
        try {
            return JidCreate.from(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static Jid fromUnescapedOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.fromUnescaped(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Jid fromUnescaped(CharSequence unescapedJid) throws XmppStringprepException {
        return JidCreate.fromUnescaped(unescapedJid.toString());
    }

    public static Jid fromUnescaped(String unescapedJidString) throws XmppStringprepException {
        String localpart = XmppStringUtils.parseLocalpart((String)unescapedJidString);
        localpart = XmppStringUtils.escapeLocalpart((String)localpart);
        String domainpart = XmppStringUtils.parseDomain((String)unescapedJidString);
        String resource = XmppStringUtils.parseResource((String)unescapedJidString);
        try {
            return JidCreate.from(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(unescapedJidString, (Exception)((Object)e));
        }
    }

    public static Jid fromUnescapedOrNull(CharSequence cs) {
        try {
            return JidCreate.fromUnescaped(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static Jid fromUrlEncoded(CharSequence cs) throws XmppStringprepException {
        String decoded = JidCreate.urlDecode(cs);
        return JidCreate.from(decoded);
    }

    public static BareJid bareFromOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.bareFrom(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static BareJid bareFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.bareFrom(jid.toString());
    }

    public static BareJid bareFrom(String jid) throws XmppStringprepException {
        BareJid bareJid = (BareJid)BAREJID_CACHE.lookup((Object)jid);
        if (bareJid != null) {
            return bareJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        try {
            bareJid = localpart.length() != 0 ? new LocalAndDomainpartJid(localpart, domainpart) : new DomainpartJid(domainpart);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        BAREJID_CACHE.put((Object)jid, (Object)bareJid);
        return bareJid;
    }

    public static BareJid bareFrom(Localpart localpart, DomainBareJid domainBareJid) {
        return JidCreate.bareFrom(localpart, domainBareJid.getDomain());
    }

    public static BareJid bareFrom(Localpart localpart, Domainpart domain) {
        if (localpart != null) {
            return new LocalAndDomainpartJid(localpart, domain);
        }
        return new DomainpartJid(domain);
    }

    public static BareJid bareFromOrNull(CharSequence cs) {
        try {
            return JidCreate.bareFrom(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static BareJid bareFromUrlEncoded(CharSequence cs) throws XmppStringprepException {
        String decoded = JidCreate.urlDecode(cs.toString());
        return JidCreate.bareFrom(decoded);
    }

    public static FullJid fullFromOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.fullFrom(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static FullJid fullFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.fullFrom(jid.toString());
    }

    public static FullJid fullFrom(String jid) throws XmppStringprepException {
        FullJid fullJid = (FullJid)FULLJID_CACHE.lookup((Object)jid);
        if (fullJid != null) {
            return fullJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        String resource = XmppStringUtils.parseResource((String)jid);
        try {
            fullJid = JidCreate.fullFrom(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        FULLJID_CACHE.put((Object)jid, (Object)fullJid);
        return fullJid;
    }

    public static FullJid fullFrom(String localpart, String domainpart, String resource) throws XmppStringprepException {
        AbstractJid fullJid;
        try {
            fullJid = localpart == null || localpart.length() == 0 ? new DomainAndResourcepartJid(domainpart, resource) : new LocalDomainAndResourcepartJid(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(localpart + '@' + domainpart + '/' + resource, (Exception)((Object)e));
        }
        return fullJid;
    }

    public static FullJid fullFrom(Localpart localpart, DomainBareJid domainBareJid, Resourcepart resource) {
        return JidCreate.fullFrom(localpart, domainBareJid.getDomain(), resource);
    }

    public static FullJid fullFrom(Localpart localpart, Domainpart domainpart, Resourcepart resource) {
        return JidCreate.fullFrom(JidCreate.entityBareFrom(localpart, domainpart), resource);
    }

    public static FullJid fullFrom(BareJid bareJid, Resourcepart resource) {
        if (bareJid.isEntityBareJid()) {
            EntityBareJid entityBareJid = (EntityBareJid)bareJid;
            return new LocalDomainAndResourcepartJid(entityBareJid, resource);
        }
        DomainBareJid domainBareJid = (DomainBareJid)bareJid;
        return new DomainAndResourcepartJid(domainBareJid, resource);
    }

    public static FullJid fullFromOrNull(CharSequence cs) {
        try {
            return JidCreate.fullFrom(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static FullJid fullFromUrlEncoded(CharSequence cs) throws XmppStringprepException {
        String decoded = JidCreate.urlDecode(cs);
        return JidCreate.fullFrom(decoded);
    }

    public static EntityJid entityFromOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.entityFrom(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EntityJid entityFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.entityFrom(jid.toString());
    }

    public static EntityJid entityFrom(String jidString) throws XmppStringprepException {
        return JidCreate.entityFrom(jidString, false);
    }

    public static EntityJid entityFromUnescapedOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.entityFromUnescaped(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EntityJid entityFromUnescaped(CharSequence jid) throws XmppStringprepException {
        return JidCreate.entityFromUnescaped(jid.toString());
    }

    public static EntityJid entityFromUnescaped(String jidString) throws XmppStringprepException {
        return JidCreate.entityFrom(jidString, true);
    }

    public static EntityJid entityFromUnesacpedOrNull(CharSequence cs) {
        try {
            return JidCreate.entityFromUnescaped(cs.toString());
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    private static EntityJid entityFrom(String jidString, boolean unescaped) throws XmppStringprepException {
        Domainpart domainpart;
        Localpart localpart;
        EntityJid entityJid = (EntityJid)ENTITYJID_CACHE.lookup((Object)jidString);
        if (entityJid != null) {
            return entityJid;
        }
        String localpartString = XmppStringUtils.parseLocalpart((String)jidString);
        if (localpartString.length() == 0) {
            throw new XmppStringprepException("Does not contain a localpart", jidString);
        }
        try {
            localpart = unescaped ? Localpart.fromUnescaped(localpartString) : Localpart.from(localpartString);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jidString, (Exception)((Object)e));
        }
        String domainpartString = XmppStringUtils.parseDomain((String)jidString);
        try {
            domainpart = Domainpart.from(domainpartString);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jidString, (Exception)((Object)e));
        }
        String resourceString = XmppStringUtils.parseResource((String)jidString);
        if (resourceString.length() > 0) {
            Resourcepart resourcepart;
            try {
                resourcepart = Resourcepart.from(resourceString);
            }
            catch (XmppStringprepException e) {
                throw new XmppStringprepException(jidString, (Exception)((Object)e));
            }
            entityJid = JidCreate.entityFullFrom(localpart, domainpart, resourcepart);
        } else {
            entityJid = JidCreate.entityBareFrom(localpart, domainpart);
        }
        ENTITYJID_CACHE.put((Object)jidString, (Object)entityJid);
        return entityJid;
    }

    public static EntityJid entityFromOrNull(CharSequence cs) {
        try {
            return JidCreate.entityFrom(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static EntityJid entityFromUrlEncoded(CharSequence cs) throws XmppStringprepException {
        String decoded = JidCreate.urlDecode(cs);
        return JidCreate.entityFrom(decoded);
    }

    public static EntityBareJid entityBareFromOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.entityBareFrom(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EntityBareJid entityBareFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.entityBareFrom(jid.toString());
    }

    public static EntityBareJid entityBareFrom(String jid) throws XmppStringprepException {
        EntityBareJid bareJid = (EntityBareJid)ENTITY_BAREJID_CACHE.lookup((Object)jid);
        if (bareJid != null) {
            return bareJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        try {
            bareJid = new LocalAndDomainpartJid(localpart, domainpart);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        ENTITY_BAREJID_CACHE.put((Object)jid, (Object)bareJid);
        return bareJid;
    }

    public static EntityBareJid entityBareFromUnescapedOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.entityBareFromUnescaped(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EntityBareJid entityBareFromUnescaped(CharSequence unescapedJid) throws XmppStringprepException {
        return JidCreate.entityBareFromUnescaped(unescapedJid.toString());
    }

    public static EntityBareJid entityBareFromUnescaped(String unescapedJidString) throws XmppStringprepException {
        EntityBareJid bareJid = (EntityBareJid)ENTITY_BAREJID_CACHE.lookup((Object)unescapedJidString);
        if (bareJid != null) {
            return bareJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)unescapedJidString);
        localpart = XmppStringUtils.escapeLocalpart((String)localpart);
        String domainpart = XmppStringUtils.parseDomain((String)unescapedJidString);
        try {
            bareJid = new LocalAndDomainpartJid(localpart, domainpart);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(unescapedJidString, (Exception)((Object)e));
        }
        ENTITY_BAREJID_CACHE.put((Object)unescapedJidString, (Object)bareJid);
        return bareJid;
    }

    public static EntityBareJid entityBareFromUnescapedOrNull(CharSequence cs) {
        try {
            return JidCreate.entityBareFromUnescaped(cs.toString());
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static EntityBareJid entityBareFrom(Localpart localpart, DomainBareJid domainBareJid) {
        return JidCreate.entityBareFrom(localpart, domainBareJid.getDomain());
    }

    public static EntityBareJid entityBareFrom(Localpart localpart, Domainpart domain) {
        return new LocalAndDomainpartJid(localpart, domain);
    }

    public static EntityBareJid entityBareFromOrNull(CharSequence cs) {
        try {
            return JidCreate.entityBareFrom(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static EntityBareJid entityBareFromUrlEncoded(CharSequence cs) throws XmppStringprepException {
        String decoded = JidCreate.urlDecode(cs);
        return JidCreate.entityBareFrom(decoded);
    }

    public static EntityFullJid entityFullFromOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.entityFullFrom(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EntityFullJid entityFullFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.entityFullFrom(jid.toString());
    }

    public static EntityFullJid entityFullFrom(String jid) throws XmppStringprepException {
        EntityFullJid fullJid = (EntityFullJid)ENTITY_FULLJID_CACHE.lookup((Object)jid);
        if (fullJid != null) {
            return fullJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)jid);
        String domainpart = XmppStringUtils.parseDomain((String)jid);
        String resource = XmppStringUtils.parseResource((String)jid);
        try {
            fullJid = JidCreate.entityFullFrom(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        ENTITY_FULLJID_CACHE.put((Object)jid, (Object)fullJid);
        return fullJid;
    }

    public static EntityFullJid entityFullFromOrNull(CharSequence cs) {
        try {
            return JidCreate.entityFullFrom(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static EntityFullJid entityFullFromUnescapedOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.entityFullFromUnescaped(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EntityFullJid entityFullFromUnescaped(CharSequence unescapedJid) throws XmppStringprepException {
        return JidCreate.entityFullFromUnescaped(unescapedJid.toString());
    }

    public static EntityFullJid entityFullFromUnescaped(String unescapedJidString) throws XmppStringprepException {
        EntityFullJid fullJid = (EntityFullJid)ENTITY_FULLJID_CACHE.lookup((Object)unescapedJidString);
        if (fullJid != null) {
            return fullJid;
        }
        String localpart = XmppStringUtils.parseLocalpart((String)unescapedJidString);
        localpart = XmppStringUtils.escapeLocalpart((String)localpart);
        String domainpart = XmppStringUtils.parseDomain((String)unescapedJidString);
        String resource = XmppStringUtils.parseResource((String)unescapedJidString);
        try {
            fullJid = new LocalDomainAndResourcepartJid(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(unescapedJidString, (Exception)((Object)e));
        }
        ENTITY_FULLJID_CACHE.put((Object)unescapedJidString, (Object)fullJid);
        return fullJid;
    }

    public static EntityFullJid entityFullFromUnescapedOrNull(CharSequence cs) {
        try {
            return JidCreate.entityFullFromUnescaped(cs.toString());
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static EntityFullJid entityFullFrom(String localpart, String domainpart, String resource) throws XmppStringprepException {
        LocalDomainAndResourcepartJid fullJid;
        try {
            fullJid = new LocalDomainAndResourcepartJid(localpart, domainpart, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(localpart + '@' + domainpart + '/' + resource, (Exception)((Object)e));
        }
        return fullJid;
    }

    public static EntityFullJid entityFullFrom(Localpart localpart, DomainBareJid domainBareJid, Resourcepart resource) {
        return JidCreate.entityFullFrom(localpart, domainBareJid.getDomain(), resource);
    }

    public static EntityFullJid entityFullFrom(Localpart localpart, Domainpart domainpart, Resourcepart resource) {
        return JidCreate.entityFullFrom(JidCreate.entityBareFrom(localpart, domainpart), resource);
    }

    public static EntityFullJid entityFullFrom(EntityBareJid bareJid, Resourcepart resource) {
        return new LocalDomainAndResourcepartJid(bareJid, resource);
    }

    public static EntityFullJid entityFullFromUrlEncoded(CharSequence cs) throws XmppStringprepException {
        String decoded = JidCreate.urlDecode(cs);
        return JidCreate.entityFullFrom(decoded);
    }

    public static DomainBareJid domainBareFromOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.domainBareFrom(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static DomainBareJid domainBareFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.domainBareFrom(jid.toString());
    }

    public static DomainBareJid domainBareFrom(String jid) throws XmppStringprepException {
        DomainBareJid domainJid = (DomainBareJid)DOMAINJID_CACHE.lookup((Object)jid);
        if (domainJid != null) {
            return domainJid;
        }
        String domain = XmppStringUtils.parseDomain((String)jid);
        try {
            domainJid = new DomainpartJid(domain);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        DOMAINJID_CACHE.put((Object)jid, (Object)domainJid);
        return domainJid;
    }

    public static DomainBareJid domainBareFrom(Domainpart domainpart) {
        return new DomainpartJid(domainpart);
    }

    public static DomainBareJid domainBareFromOrNull(CharSequence cs) {
        try {
            return JidCreate.domainBareFrom(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static DomainBareJid domainBareFromUrlEncoded(CharSequence cs) throws XmppStringprepException {
        String decode = JidCreate.urlDecode(cs);
        return JidCreate.domainBareFrom(decode);
    }

    public static DomainFullJid domainFullFromOrThrowUnchecked(CharSequence cs) {
        try {
            return JidCreate.domainFullFrom(cs);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static DomainFullJid domainFullFrom(CharSequence jid) throws XmppStringprepException {
        return JidCreate.domainFullFrom(jid.toString());
    }

    public static DomainFullJid domainFullFrom(String jid) throws XmppStringprepException {
        DomainFullJid domainResourceJid = (DomainFullJid)DOMAINRESOURCEJID_CACHE.lookup((Object)jid);
        if (domainResourceJid != null) {
            return domainResourceJid;
        }
        String domain = XmppStringUtils.parseDomain((String)jid);
        String resource = XmppStringUtils.parseResource((String)jid);
        try {
            domainResourceJid = new DomainAndResourcepartJid(domain, resource);
        }
        catch (XmppStringprepException e) {
            throw new XmppStringprepException(jid, (Exception)((Object)e));
        }
        DOMAINRESOURCEJID_CACHE.put((Object)jid, (Object)domainResourceJid);
        return domainResourceJid;
    }

    public static DomainFullJid domainFullFrom(Domainpart domainpart, Resourcepart resource) {
        return JidCreate.domainFullFrom(JidCreate.domainBareFrom(domainpart), resource);
    }

    public static DomainFullJid domainFullFrom(DomainBareJid domainBareJid, Resourcepart resource) {
        return new DomainAndResourcepartJid(domainBareJid, resource);
    }

    public static DomainFullJid domainFullFromOrNull(CharSequence cs) {
        try {
            return JidCreate.domainFullFrom(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static DomainFullJid domainFullFromUrlEncoded(CharSequence cs) throws XmppStringprepException {
        String decoded = JidCreate.urlDecode(cs);
        return JidCreate.domainFullFrom(decoded);
    }

    private static String urlDecode(CharSequence cs) {
        try {
            return URLDecoder.decode(cs.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

