/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;

public class JidSerializableTest {
    @Test
    public void basicTest() throws IOException, ClassNotFoundException {
        Jid jid = JidCreate.from((String)"foo@bar.org");
        Jid deserializedJid = JidSerializableTest.serializeAndDeserialize(jid);
        Assert.assertEquals((Object)jid, (Object)deserializedJid);
    }

    @Test
    public void localAndDomainpartTest() throws ClassNotFoundException, IOException {
        EntityBareJid bareJid = JidTestUtil.BARE_JID_1;
        EntityBareJid deserializedBareJid = JidSerializableTest.serializeAndDeserialize(bareJid);
        Assert.assertEquals((Object)bareJid, (Object)deserializedBareJid);
    }

    @Test
    public void localDomainAndResourcepartTest() throws ClassNotFoundException, IOException {
        EntityFullJid fullJid = JidTestUtil.FULL_JID_1_RESOURCE_1;
        EntityFullJid deserializedFullJid = JidSerializableTest.serializeAndDeserialize(fullJid);
        Assert.assertEquals((Object)fullJid, (Object)deserializedFullJid);
    }

    @Test
    public void domainpartJidTest() throws ClassNotFoundException, IOException {
        DomainBareJid domainpartJid = JidTestUtil.DOMAIN_BARE_JID_1;
        DomainBareJid deserializedDomainpartJid = JidSerializableTest.serializeAndDeserialize(domainpartJid);
        Assert.assertEquals((Object)domainpartJid, (Object)deserializedDomainpartJid);
    }

    @Test
    public void domainAndResourcepartTest() throws ClassNotFoundException, IOException {
        DomainFullJid domainFullJid = JidTestUtil.DOMAIN_FULL_JID_1;
        DomainFullJid deserializedDomainFullJid = JidSerializableTest.serializeAndDeserialize(domainFullJid);
        Assert.assertEquals((Object)domainFullJid, (Object)deserializedDomainFullJid);
    }

    private static <S> S serializeAndDeserialize(S serializable) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(serializable);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        return (S)ois.readObject();
    }
}

