/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid;

import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class JidTest {
    @Test
    public void testJidIsParentOf() throws XmppStringprepException {
        Jid domainBareJid = JidCreate.from((String)"dom.example");
        Jid domainFullJid = JidCreate.from((String)"dom.example/res");
        Jid bareJid = JidCreate.from((String)"loc@dom.example");
        Jid fullJid = JidCreate.from((String)"loc@dom.example/res");
        Assert.assertTrue((boolean)domainBareJid.isParentOf(domainBareJid));
        Assert.assertTrue((boolean)domainBareJid.isParentOf(domainFullJid));
        Assert.assertTrue((boolean)domainBareJid.isParentOf(bareJid));
        Assert.assertTrue((boolean)domainBareJid.isParentOf(fullJid));
        Assert.assertFalse((boolean)domainFullJid.isParentOf(domainBareJid));
        Assert.assertTrue((boolean)domainFullJid.isParentOf(domainFullJid));
        Assert.assertFalse((boolean)domainFullJid.isParentOf(bareJid));
        Assert.assertFalse((boolean)domainFullJid.isParentOf(fullJid));
        Assert.assertFalse((boolean)bareJid.isParentOf(domainBareJid));
        Assert.assertFalse((boolean)bareJid.isParentOf(domainFullJid));
        Assert.assertTrue((boolean)bareJid.isParentOf(bareJid));
        Assert.assertTrue((boolean)bareJid.isParentOf(fullJid));
        Assert.assertFalse((boolean)fullJid.isParentOf(domainBareJid));
        Assert.assertFalse((boolean)fullJid.isParentOf(domainFullJid));
        Assert.assertFalse((boolean)fullJid.isParentOf(bareJid));
        Assert.assertTrue((boolean)fullJid.isParentOf(fullJid));
    }

    @Test
    public void stripFinalDot() throws XmppStringprepException {
        String domain = "foo.bar.";
        DomainBareJid jid = JidCreate.domainBareFrom((String)domain);
        Assert.assertEquals((Object)"foo.bar", (Object)jid.toString());
    }
}

